/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.annotation;

import com.navercorp.pinpoint.grpc.trace.PAnnotationValue;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAnnotationSerializable;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcAnnotationValueMapper;
import com.navercorp.pinpoint.profiler.context.thrift.AnnotationValueThriftMapper;
import com.navercorp.pinpoint.profiler.context.thrift.ThriftAnnotationSerializable;
import com.navercorp.pinpoint.thrift.dto.TAnnotationValue;

public class LongAnnotation
implements Annotation<Long>,
GrpcAnnotationSerializable,
ThriftAnnotationSerializable {
    private final int key;
    private final long value;

    LongAnnotation(int key, long value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public int getAnnotationKey() {
        return this.getKey();
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public Long getValue() {
        return this.value;
    }

    @Override
    public PAnnotationValue apply(GrpcAnnotationValueMapper context) {
        PAnnotationValue.Builder builder = context.getAnnotationBuilder();
        builder.setLongValue(this.value);
        return builder.build();
    }

    @Override
    public TAnnotationValue apply(AnnotationValueThriftMapper context) {
        return TAnnotationValue.longValue((long)this.value);
    }

    public String toString() {
        return "LongAnnotation{" + this.key + "=" + this.value + '}';
    }
}

