/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.module;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.navercorp.pinpoint.bootstrap.AgentOption;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.instrument.DynamicTransformTrigger;
import com.navercorp.pinpoint.bootstrap.module.ClassFileTransformModuleAdaptor;
import com.navercorp.pinpoint.bootstrap.module.JavaModuleFactory;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import com.navercorp.pinpoint.profiler.AgentInfoSender;
import com.navercorp.pinpoint.profiler.AgentInformation;
import com.navercorp.pinpoint.profiler.context.ServerMetaDataRegistryService;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.javamodule.ClassFileTransformerModuleHandler;
import com.navercorp.pinpoint.profiler.context.javamodule.JavaModuleFactoryFinder;
import com.navercorp.pinpoint.profiler.context.module.ApplicationContext;
import com.navercorp.pinpoint.profiler.context.module.ModuleFactory;
import com.navercorp.pinpoint.profiler.context.module.ModuleLifeCycle;
import com.navercorp.pinpoint.profiler.context.module.SpanDataSender;
import com.navercorp.pinpoint.profiler.context.provider.ShutdownHookRegisterProvider;
import com.navercorp.pinpoint.profiler.instrument.BytecodeDumpTransformer;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.lambda.LambdaTransformBootloader;
import com.navercorp.pinpoint.profiler.interceptor.registry.InterceptorRegistryBinder;
import com.navercorp.pinpoint.profiler.monitor.AgentStatMonitor;
import com.navercorp.pinpoint.profiler.monitor.DeadlockMonitor;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import java.lang.annotation.Annotation;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultApplicationContext
implements ApplicationContext {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ProfilerConfig profilerConfig;
    private final DeadlockMonitor deadlockMonitor;
    private final AgentInfoSender agentInfoSender;
    private final AgentStatMonitor agentStatMonitor;
    private final TraceContext traceContext;
    private final ModuleLifeCycle rpcModuleLifeCycle;
    private final AgentInformation agentInformation;
    private final ServerMetaDataRegistryService serverMetaDataRegistryService;
    private final ClassFileTransformer classFileTransformer;
    private final InstrumentEngine instrumentEngine;
    private final DynamicTransformTrigger dynamicTransformTrigger;
    private final InterceptorRegistryBinder interceptorRegistryBinder;
    private final Injector injector;

    public DefaultApplicationContext(AgentOption agentOption, ModuleFactory moduleFactory) {
        Objects.requireNonNull(agentOption, "agentOption");
        Objects.requireNonNull(moduleFactory, "moduleFactory");
        Objects.requireNonNull(agentOption.getProfilerConfig(), "profilerConfig");
        Instrumentation instrumentation = agentOption.getInstrumentation();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("DefaultAgent classLoader:{}", (Object)this.getClass().getClassLoader());
        }
        Module applicationContextModule = moduleFactory.newModule(agentOption);
        this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{applicationContextModule});
        this.profilerConfig = (ProfilerConfig)this.injector.getInstance(ProfilerConfig.class);
        this.interceptorRegistryBinder = (InterceptorRegistryBinder)this.injector.getInstance(InterceptorRegistryBinder.class);
        this.instrumentEngine = (InstrumentEngine)this.injector.getInstance(InstrumentEngine.class);
        this.classFileTransformer = (ClassFileTransformer)this.injector.getInstance(ClassFileTransformer.class);
        this.dynamicTransformTrigger = (DynamicTransformTrigger)this.injector.getInstance(DynamicTransformTrigger.class);
        ClassFileTransformer classFileTransformer = this.wrap(this.classFileTransformer);
        JvmVersion version = JvmUtils.getVersion();
        if (version.onOrAfter(JvmVersion.JAVA_9)) {
            JavaModuleFactory javaModuleFactory = JavaModuleFactoryFinder.lookup(instrumentation);
            ClassFileTransformerModuleHandler classFileTransformModuleAdaptor = new ClassFileTransformerModuleHandler(instrumentation, classFileTransformer, javaModuleFactory);
            classFileTransformer = this.wrapJava9ClassFileTransformer(classFileTransformModuleAdaptor);
            this.lambdaFactorySetup(instrumentation, classFileTransformModuleAdaptor, javaModuleFactory);
            instrumentation.addTransformer(classFileTransformer, true);
        } else {
            instrumentation.addTransformer(classFileTransformer, true);
        }
        this.rpcModuleLifeCycle = (ModuleLifeCycle)this.injector.getInstance(Key.get(ModuleLifeCycle.class, (Annotation)Names.named((String)"RPC-MODULE")));
        this.logger.info("rpcModuleLifeCycle:{}", (Object)this.rpcModuleLifeCycle);
        this.rpcModuleLifeCycle.start();
        this.traceContext = (TraceContext)this.injector.getInstance(TraceContext.class);
        this.agentInformation = (AgentInformation)this.injector.getInstance(AgentInformation.class);
        this.logger.info("agentInformation:{}", (Object)this.agentInformation);
        this.serverMetaDataRegistryService = (ServerMetaDataRegistryService)this.injector.getInstance(ServerMetaDataRegistryService.class);
        this.deadlockMonitor = (DeadlockMonitor)this.injector.getInstance(DeadlockMonitor.class);
        this.agentInfoSender = (AgentInfoSender)this.injector.getInstance(AgentInfoSender.class);
        this.agentStatMonitor = (AgentStatMonitor)this.injector.getInstance(AgentStatMonitor.class);
    }

    private void lambdaFactorySetup(Instrumentation instrumentation, ClassFileTransformModuleAdaptor classFileTransformer, JavaModuleFactory javaModuleFactory) {
        JvmVersion version = JvmUtils.getVersion();
        if (version.onOrAfter(JvmVersion.JAVA_9)) {
            LambdaTransformBootloader lambdaTransformBootloader = new LambdaTransformBootloader();
            lambdaTransformBootloader.transformLambdaFactory(instrumentation, classFileTransformer, javaModuleFactory);
        }
    }

    private ClassFileTransformer wrapJava9ClassFileTransformer(ClassFileTransformModuleAdaptor classFileTransformer) {
        this.logger.info("initialize Java9ClassFileTransformer");
        String moduleWrap = "com.navercorp.pinpoint.bootstrap.java9.module.ClassFileTransformerModuleWrap";
        try {
            Class<?> cftClass = this.forName(moduleWrap, Object.class.getClassLoader());
            Constructor<?> constructor = cftClass.getDeclaredConstructor(ClassFileTransformModuleAdaptor.class);
            return (ClassFileTransformer)constructor.newInstance(classFileTransformer);
        }
        catch (Exception e) {
            throw new IllegalStateException(moduleWrap + " load fail Caused by:" + e.getMessage(), e);
        }
    }

    private Class<?> forName(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(className + " not found");
        }
    }

    private ClassFileTransformer wrap(ClassFileTransformer classFileTransformer) {
        boolean enableBytecodeDump = this.profilerConfig.readBoolean("bytecode.dump.enable", false);
        if (enableBytecodeDump) {
            this.logger.info("wrapBytecodeDumpTransformer");
            return BytecodeDumpTransformer.wrap(classFileTransformer, this.profilerConfig);
        }
        return classFileTransformer;
    }

    public ProfilerConfig getProfilerConfig() {
        return this.profilerConfig;
    }

    public Injector getInjector() {
        return this.injector;
    }

    public TraceContext getTraceContext() {
        return this.traceContext;
    }

    public ShutdownHookRegisterProvider getShutdownHookRegisterProvider() {
        return (ShutdownHookRegisterProvider)this.injector.getInstance(ShutdownHookRegisterProvider.class);
    }

    public DataSender<SpanType> getSpanDataSender() {
        TypeLiteral<DataSender<SpanType>> spanDataSenderType = new TypeLiteral<DataSender<SpanType>>(){};
        Key spanDataSenderKey = Key.get((TypeLiteral)spanDataSenderType, SpanDataSender.class);
        return (DataSender)this.injector.getInstance(spanDataSenderKey);
    }

    public InstrumentEngine getInstrumentEngine() {
        return this.instrumentEngine;
    }

    public DynamicTransformTrigger getDynamicTransformTrigger() {
        return this.dynamicTransformTrigger;
    }

    public ClassFileTransformer getClassFileTransformer() {
        return this.classFileTransformer;
    }

    public AgentInformation getAgentInformation() {
        return this.agentInformation;
    }

    public ServerMetaDataRegistryService getServerMetaDataRegistryService() {
        return this.serverMetaDataRegistryService;
    }

    @Override
    public void start() {
        this.interceptorRegistryBinder.bind();
        this.deadlockMonitor.start();
        this.agentInfoSender.start();
        this.agentStatMonitor.start();
    }

    @Override
    public void close() {
        this.agentInfoSender.stop();
        this.agentStatMonitor.stop();
        this.deadlockMonitor.stop();
        if (this.rpcModuleLifeCycle != null) {
            this.rpcModuleLifeCycle.shutdown();
        }
        if (this.profilerConfig.getStaticResourceCleanup()) {
            this.interceptorRegistryBinder.unbind();
        }
    }
}

