/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.module;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.util.JvmUtils;
import com.navercorp.pinpoint.common.util.JvmVersion;
import com.navercorp.pinpoint.profiler.util.PropertyRollbackTemplate;
import io.netty.util.internal.PlatformDependent;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NettyPlatformDependent {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ProfilerConfig profilerConfig;
    private final Properties properties;

    public NettyPlatformDependent(ProfilerConfig profilerConfig, Properties properties) {
        this.profilerConfig = profilerConfig;
        this.properties = properties;
    }

    public void setup() {
        boolean noPreferDirect;
        boolean tryReflectionSetAccessible = this.profilerConfig.readBoolean("profiler.system.property.io.netty.tryReflectionSetAccessible", true);
        PropertyRollbackTemplate template = new PropertyRollbackTemplate(this.properties);
        if (tryReflectionSetAccessible && JvmUtils.getVersion().onOrAfter(JvmVersion.JAVA_9)) {
            String keySystemProperty = "io.netty.tryReflectionSetAccessible";
            String tryReflectionSetAccessibleString = String.valueOf(tryReflectionSetAccessible);
            template.addKey("io.netty.tryReflectionSetAccessible", tryReflectionSetAccessibleString);
        }
        if (noPreferDirect = this.profilerConfig.readBoolean("profiler.system.property.io.netty.noPreferDirect", false)) {
            String noPreferDirectKey = "io.netty.noPreferDirect";
            String noPreferDirectValue = String.valueOf(noPreferDirect);
            template.addKey("io.netty.noPreferDirect", noPreferDirectValue);
        }
        template.execute(new Runnable(){

            @Override
            public void run() {
                PlatformDependent.addressSize();
                NettyPlatformDependent.this.logger.info("PlatformDependent.hasUnsafe:{}", (Object)PlatformDependent.hasUnsafe());
            }
        });
    }
}

