/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.recorder;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.ParsingResult;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.DataType;
import com.navercorp.pinpoint.common.util.IntStringStringValue;
import com.navercorp.pinpoint.common.util.StringUtils;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.AsyncContextFactory;
import com.navercorp.pinpoint.profiler.context.AsyncId;
import com.navercorp.pinpoint.profiler.context.DefaultTrace;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.SpanEventFactory;
import com.navercorp.pinpoint.profiler.context.annotation.Annotations;
import com.navercorp.pinpoint.profiler.context.errorhandler.IgnoreErrorHandler;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.recorder.AbstractRecorder;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WrappedSpanEventRecorder
extends AbstractRecorder
implements SpanEventRecorder {
    private static final Logger logger = LogManager.getLogger((String)DefaultTrace.class.getName());
    private static final boolean isDebug = logger.isDebugEnabled();
    protected final TraceRoot traceRoot;
    protected final AsyncContextFactory asyncContextFactory;
    private SpanEvent spanEvent;

    public WrappedSpanEventRecorder(TraceRoot traceRoot, AsyncContextFactory asyncContextFactory, StringMetaDataService stringMetaDataService, SqlMetaDataService sqlMetaCacheService, IgnoreErrorHandler errorHandler) {
        super(stringMetaDataService, sqlMetaCacheService, errorHandler);
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
        this.asyncContextFactory = Objects.requireNonNull(asyncContextFactory, "asyncContextFactory");
    }

    public void setWrapped(SpanEvent spanEvent) {
        this.spanEvent = spanEvent;
    }

    public ParsingResult recordSqlInfo(String sql) {
        if (sql == null) {
            return null;
        }
        ParsingResult parsingResult = this.sqlMetaDataService.parseSql(sql);
        this.recordSqlParsingResult(parsingResult);
        return parsingResult;
    }

    public void recordSqlParsingResult(ParsingResult parsingResult) {
        this.recordSqlParsingResult(parsingResult, null);
    }

    public void recordSqlParsingResult(ParsingResult parsingResult, String bindValue) {
        if (parsingResult == null) {
            return;
        }
        boolean isNewCache = this.sqlMetaDataService.cacheSql(parsingResult);
        if (isDebug) {
            if (isNewCache) {
                logger.debug("update sql cache. parsingResult:{}", (Object)parsingResult);
            } else {
                logger.debug("cache hit. parsingResult:{}", (Object)parsingResult);
            }
        }
        String output = StringUtils.defaultIfEmpty((String)parsingResult.getOutput(), null);
        bindValue = StringUtils.defaultIfEmpty((String)bindValue, null);
        IntStringStringValue sqlValue = new IntStringStringValue(parsingResult.getId(), output, bindValue);
        this.recordSqlParam(sqlValue);
    }

    private void recordSqlParam(IntStringStringValue intStringStringValue) {
        Annotation<DataType> annotation = Annotations.of(AnnotationKey.SQL_ID.getCode(), (DataType)intStringStringValue);
        this.spanEvent.addAnnotation(annotation);
    }

    public void recordDestinationId(String destinationId) {
        this.spanEvent.setDestinationId(destinationId);
    }

    public void recordNextSpanId(long nextSpanId) {
        if (nextSpanId == -1L) {
            return;
        }
        this.spanEvent.setNextSpanId(nextSpanId);
    }

    public AsyncContext recordNextAsyncContext() {
        TraceRoot traceRoot = this.traceRoot;
        AsyncId asyncIdObject = this.getNextAsyncId();
        boolean canSampled = this.isOverflowState();
        return this.asyncContextFactory.newAsyncContext(traceRoot, asyncIdObject, canSampled);
    }

    protected boolean isOverflowState() {
        return !SpanEventFactory.isDisableSpanEvent(this.spanEvent);
    }

    public AsyncContext recordNextAsyncContext(boolean asyncStateSupport) {
        return this.recordNextAsyncContext();
    }

    @Override
    void maskErrorCode(int errorCode) {
        this.traceRoot.getShared().maskErrorCode(errorCode);
    }

    @Override
    void setExceptionInfo(int exceptionClassId, String exceptionMessage) {
        this.spanEvent.setExceptionInfo(exceptionClassId, exceptionMessage);
    }

    public void recordApiId(int apiId) {
        this.setApiId0(apiId);
    }

    @Override
    void setApiId0(int apiId) {
        this.spanEvent.setApiId(apiId);
    }

    @Override
    void addAnnotation(Annotation<?> annotation) {
        this.spanEvent.addAnnotation(annotation);
    }

    public void recordServiceType(ServiceType serviceType) {
        this.spanEvent.setServiceType(serviceType.getCode());
    }

    public void recordEndPoint(String endPoint) {
        this.spanEvent.setEndPoint(endPoint);
    }

    public void recordTime(boolean time) {
        this.spanEvent.setTimeRecording(time);
        if (time) {
            if (this.spanEvent.getStartTime() != 0L) {
                this.spanEvent.markStartTime();
            }
        } else {
            this.spanEvent.setStartTime(0L);
            this.spanEvent.setElapsedTime(0);
        }
    }

    public Object detachFrameObject() {
        return this.spanEvent.detachFrameObject();
    }

    public Object getFrameObject() {
        return this.spanEvent.getFrameObject();
    }

    public Object attachFrameObject(Object frameObject) {
        return this.spanEvent.attachFrameObject(frameObject);
    }

    protected AsyncId getNextAsyncId() {
        AsyncId nextAsyncId = this.spanEvent.getAsyncIdObject();
        if (nextAsyncId == null) {
            nextAsyncId = this.asyncContextFactory.newAsyncId();
            this.spanEvent.setAsyncIdObject(nextAsyncId);
        }
        return nextAsyncId;
    }
}

