/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.storage;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.profiler.context.storage.UriStatStorage;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.AgentUriStatData;
import com.navercorp.pinpoint.profiler.monitor.metric.uri.UriStatInfo;
import com.navercorp.pinpoint.profiler.sender.AsyncQueueingExecutor;
import com.navercorp.pinpoint.profiler.sender.AsyncQueueingExecutorListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AsyncQueueingUriStatStorage
extends AsyncQueueingExecutor<UriStatInfo>
implements UriStatStorage {
    private static final Logger LOGGER = LogManager.getLogger(AsyncQueueingUriStatStorage.class);
    private final ExecutorListener executorListener;

    public AsyncQueueingUriStatStorage(int queueSize, int uriStatDataLimitSize, String executorName) {
        this(queueSize, executorName, new ExecutorListener(uriStatDataLimitSize));
    }

    public AsyncQueueingUriStatStorage(int queueSize, int uriStatDataLimitSize, String executorName, int collectInterval) {
        this(queueSize, executorName, new ExecutorListener(uriStatDataLimitSize, collectInterval));
    }

    private AsyncQueueingUriStatStorage(int queueSize, String executorName, ExecutorListener executorListener) {
        super(queueSize, executorName, executorListener);
        this.executorListener = executorListener;
    }

    @Override
    public void store(String uri, boolean status, long elapsedTime) {
        Objects.requireNonNull(uri, "uri");
        UriStatInfo uriStatInfo = new UriStatInfo(uri, status, elapsedTime);
        this.execute(uriStatInfo);
    }

    @Override
    public AgentUriStatData poll() {
        return this.executorListener.pollCompletedData();
    }

    @Override
    public void close() {
        this.stop();
    }

    @Override
    protected void pollTimeout(long timeout) {
        this.executorListener.executePollTimeout();
    }

    private static class ExecutorListener
    implements AsyncQueueingExecutorListener<UriStatInfo> {
        private static final int DEFAULT_COLLECT_INTERVAL = 60000;
        private final Object lock = new Object();
        private final int uriStatDataLimitSize;
        private final int collectInterval;
        private final LinkedList<AgentUriStatData> completedUriStatDataList;
        private AgentUriStatData currentAgentUriStatData;

        public ExecutorListener(int uriStatDataLimitSize) {
            this(uriStatDataLimitSize, 60000);
        }

        public ExecutorListener(int uriStatDataLimitSize, int collectInterval) {
            Assert.isTrue((uriStatDataLimitSize > 0 ? 1 : 0) != 0, (String)"uriStatDataLimitSize must be ' > 0'");
            this.uriStatDataLimitSize = uriStatDataLimitSize;
            Assert.isTrue((collectInterval > 0 ? 1 : 0) != 0, (String)"collectInterval must be ' > 0'");
            this.collectInterval = collectInterval;
            this.completedUriStatDataList = new LinkedList();
        }

        @Override
        public void execute(Collection<UriStatInfo> messageList) {
            long currentBaseTimestamp = this.getBaseTimestamp();
            this.checkAndFlushOldData(currentBaseTimestamp);
            AgentUriStatData agentUriStatData = this.getCurrent(currentBaseTimestamp);
            Object[] dataList = messageList.toArray();
            for (int i = 0; i < CollectionUtils.nullSafeSize(messageList); ++i) {
                try {
                    agentUriStatData.add((UriStatInfo)dataList[i]);
                    continue;
                }
                catch (Throwable th) {
                    LOGGER.warn("Unexpected Error. Cause:{}", (Object)th.getMessage(), (Object)th);
                }
            }
        }

        @Override
        public void execute(UriStatInfo message) {
            long currentBaseTimestamp = this.getBaseTimestamp();
            this.checkAndFlushOldData(currentBaseTimestamp);
            AgentUriStatData agentUriStatData = this.getCurrent(currentBaseTimestamp);
            agentUriStatData.add(message);
        }

        public void executePollTimeout() {
            long currentBaseTimestamp = this.getBaseTimestamp();
            this.checkAndFlushOldData(currentBaseTimestamp);
        }

        private long getBaseTimestamp() {
            long currentTimeMillis = System.currentTimeMillis();
            long timestamp = currentTimeMillis - currentTimeMillis % (long)this.collectInterval;
            return timestamp;
        }

        private boolean checkAndFlushOldData(long currentBaseTimestamp) {
            if (this.currentAgentUriStatData == null) {
                return false;
            }
            if (currentBaseTimestamp > this.currentAgentUriStatData.getBaseTimestamp()) {
                this.addCompletedData(this.currentAgentUriStatData);
                this.currentAgentUriStatData = null;
                return true;
            }
            return false;
        }

        private AgentUriStatData getCurrent(long currentBaseTimestamp) {
            if (this.currentAgentUriStatData == null) {
                this.currentAgentUriStatData = new AgentUriStatData(currentBaseTimestamp);
            }
            return this.currentAgentUriStatData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addCompletedData(AgentUriStatData agentUriStatData) {
            Object object = this.lock;
            synchronized (object) {
                if (this.completedUriStatDataList.size() >= this.uriStatDataLimitSize) {
                    this.completedUriStatDataList.remove();
                }
                this.completedUriStatDataList.add(agentUriStatData);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AgentUriStatData pollCompletedData() {
            Object object = this.lock;
            synchronized (object) {
                if (this.completedUriStatDataList.isEmpty()) {
                    return null;
                }
                return this.completedUriStatDataList.remove();
            }
        }
    }
}

