/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.jdbc;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.jdbc.BytesConverter;
import com.navercorp.pinpoint.profiler.jdbc.ClassNameConverter;
import com.navercorp.pinpoint.profiler.jdbc.Converter;
import com.navercorp.pinpoint.profiler.jdbc.HexBytesConverter;
import com.navercorp.pinpoint.profiler.jdbc.NullTypeConverter;
import com.navercorp.pinpoint.profiler.jdbc.ObjectConverter;
import com.navercorp.pinpoint.profiler.jdbc.SimpleTypeConverter;
import java.util.HashMap;
import java.util.Map;

public class BindValueConverter {
    static final int DEFAULT_ABBREVIATE_MAX_WIDTH = 32;
    private final int maxWidth;
    private final Map<String, Converter> converterMap = new HashMap<String, Converter>();

    public static BindValueConverter defaultBindValueConverter() {
        return BindValueConverter.defaultBindValueConverter(32);
    }

    public static BindValueConverter defaultBindValueConverter(int maxWidth) {
        BindValueConverter converter = new BindValueConverter(maxWidth);
        converter.simpleType();
        converter.classNameType();
        converter.setNullConverter();
        converter.setHexBytesConverter();
        converter.setObjectConverter();
        return converter;
    }

    public BindValueConverter() {
        this(32);
    }

    public BindValueConverter(int maxWidth) {
        this.maxWidth = maxWidth;
        Assert.isTrue((maxWidth > 0 ? 1 : 0) != 0, (String)"negative abbreviateMaxWidth");
    }

    private void register(String methodName, Converter converter) {
        this.converterMap.put(methodName, converter);
    }

    private void classNameType() {
        ClassNameConverter classNameConverter = new ClassNameConverter();
        this.register("setAsciiStream", classNameConverter);
        this.register("setUnicodeStream", classNameConverter);
        this.register("setBinaryStream", classNameConverter);
        this.register("setBlob", classNameConverter);
        this.register("setClob", classNameConverter);
        this.register("setArray", classNameConverter);
        this.register("setNCharacterStream", classNameConverter);
        this.register("setNClob", classNameConverter);
        this.register("setCharacterStream", classNameConverter);
        this.register("setSQLXML", classNameConverter);
    }

    public void setRawBytesConverter() {
        this.register("setBytes", new BytesConverter(this.maxWidth));
    }

    public void setHexBytesConverter() {
        this.register("setBytes", new HexBytesConverter(this.maxWidth));
    }

    private void setObjectConverter() {
        this.register("setObject", new ObjectConverter(this.maxWidth));
    }

    private void setNullConverter() {
        this.register("setNull", new NullTypeConverter());
    }

    private void simpleType() {
        SimpleTypeConverter simpleTypeConverter = new SimpleTypeConverter(this.maxWidth);
        this.register("setByte", simpleTypeConverter);
        this.register("setBoolean", simpleTypeConverter);
        this.register("setShort", simpleTypeConverter);
        this.register("setInt", simpleTypeConverter);
        this.register("setLong", simpleTypeConverter);
        this.register("setFloat", simpleTypeConverter);
        this.register("setDouble", simpleTypeConverter);
        this.register("setBigDecimal", simpleTypeConverter);
        this.register("setString", simpleTypeConverter);
        this.register("setDate", simpleTypeConverter);
        this.register("setTime", simpleTypeConverter);
        this.register("setTimestamp", simpleTypeConverter);
        this.register("setURL", simpleTypeConverter);
        this.register("setRef", simpleTypeConverter);
        this.register("setNString", simpleTypeConverter);
    }

    public String convert(String methodName, Object[] args) {
        Converter converter = this.converterMap.get(methodName);
        if (converter == null) {
            return "";
        }
        return converter.convert(args);
    }
}

