/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.jdbc;

import com.navercorp.pinpoint.common.util.MapUtils;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.Map;

public final class BindValueUtils {
    private BindValueUtils() {
    }

    public static String bindValueToString(Map<Integer, String> bindValueMap, int limit) {
        if (MapUtils.isEmpty(bindValueMap)) {
            return "";
        }
        int maxParameterIndex = BindValueUtils.getMaxParameterIndex(bindValueMap);
        if (maxParameterIndex <= 0) {
            return "";
        }
        String[] temp = new String[maxParameterIndex];
        for (Map.Entry<Integer, String> entry : bindValueMap.entrySet()) {
            int parameterIndex = entry.getKey() - 1;
            if (parameterIndex < 0 || temp.length <= parameterIndex) continue;
            temp[parameterIndex] = entry.getValue();
        }
        return BindValueUtils.bindValueToString(temp, limit);
    }

    private static int getMaxParameterIndex(Map<Integer, String> bindValueMap) {
        int maxIndex = 0;
        for (Integer idx : bindValueMap.keySet()) {
            maxIndex = Math.max(maxIndex, idx);
        }
        return maxIndex;
    }

    public static String bindValueToString(String[] bindValueArray, int limit) {
        if (bindValueArray == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(32);
        int length = bindValueArray.length;
        int end = length - 1;
        for (int i = 0; i < length; ++i) {
            if (sb.length() >= limit) {
                BindValueUtils.appendLength(sb, length);
                break;
            }
            String bindValue = StringUtils.defaultString((String)bindValueArray[i], (String)"");
            StringUtils.appendAbbreviate((StringBuilder)sb, (String)bindValue, (int)limit);
            if (i >= end) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static void appendLength(StringBuilder sb, int length) {
        sb.append("...(");
        sb.append(length);
        sb.append(')');
    }

    public static String bindValueToString(String[] stringArray) {
        return BindValueUtils.bindValueToString(stringArray, Integer.MAX_VALUE);
    }
}

