/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.uri.UriExtractorProvider;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.loader.plugins.profiler.ProfilerPluginLoader;
import com.navercorp.pinpoint.profiler.plugin.PluginContextLoadResult;
import com.navercorp.pinpoint.profiler.plugin.PluginSetupResult;
import com.navercorp.pinpoint.profiler.plugin.PluginsSetupResult;
import com.navercorp.pinpoint.profiler.plugin.ProfilerPluginContextLoader;
import java.lang.instrument.ClassFileTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DefaultPluginContextLoadResult
implements PluginContextLoadResult {
    private final PluginsSetupResult pluginsSetupResult;

    public DefaultPluginContextLoadResult(ProfilerPluginContextLoader profilerPluginContextLoader, ClassLoader pluginClassLoader) {
        Objects.requireNonNull(profilerPluginContextLoader, "profilerPluginConfigurer");
        Objects.requireNonNull(pluginClassLoader, "pluginClassLoader");
        ProfilerPluginLoader profilerPluginLoader = new ProfilerPluginLoader();
        List profilerPlugins = profilerPluginLoader.load(pluginClassLoader);
        this.pluginsSetupResult = profilerPluginContextLoader.load(profilerPlugins);
    }

    @Override
    public List<ClassFileTransformer> getClassFileTransformer() {
        ArrayList<ClassFileTransformer> transformerList = new ArrayList<ClassFileTransformer>();
        for (PluginSetupResult pluginContext : this.pluginsSetupResult.getPluginSetupResults()) {
            List<ClassFileTransformer> classTransformerList = pluginContext.getClassTransformerList();
            transformerList.addAll(classTransformerList);
        }
        return transformerList;
    }

    @Override
    public ServiceType getApplicationType() {
        return this.pluginsSetupResult.getApplicationType();
    }

    @Override
    public List<JdbcUrlParserV2> getJdbcUrlParserList() {
        ArrayList<JdbcUrlParserV2> result = new ArrayList<JdbcUrlParserV2>();
        for (PluginSetupResult context : this.pluginsSetupResult.getPluginSetupResults()) {
            List<JdbcUrlParserV2> jdbcUrlParserList = context.getJdbcUrlParserList();
            result.addAll(jdbcUrlParserList);
        }
        return result;
    }

    @Override
    public List<UriExtractorProvider> getUriExtractorProviderList() {
        ArrayList<UriExtractorProvider> result = new ArrayList<UriExtractorProvider>();
        for (PluginSetupResult context : this.pluginsSetupResult.getPluginSetupResults()) {
            List<UriExtractorProvider> uriExtractorProviderList = context.getUriExtractorProviderList();
            result.addAll(uriExtractorProviderList);
        }
        return result;
    }
}

