/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.uri.UriExtractorProvider;
import com.navercorp.pinpoint.common.trace.ServiceType;
import java.util.Objects;

public class GuardProfilerPluginSetupContext
implements ProfilerPluginSetupContext {
    private final ProfilerPluginSetupContext delegate;
    private boolean close = false;

    public GuardProfilerPluginSetupContext(ProfilerPluginSetupContext delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    public ProfilerConfig getConfig() {
        return this.delegate.getConfig();
    }

    public ServiceType getConfiguredApplicationType() {
        return this.delegate.getConfiguredApplicationType();
    }

    public ServiceType getApplicationType() {
        return this.delegate.getApplicationType();
    }

    public boolean registerApplicationType(ServiceType applicationType) {
        this.checkOpen();
        return this.delegate.registerApplicationType(applicationType);
    }

    public void addJdbcUrlParser(JdbcUrlParserV2 jdbcUrlParser) {
        this.checkOpen();
        this.delegate.addJdbcUrlParser(jdbcUrlParser);
    }

    public void addUriExtractor(UriExtractorProvider uriExtractorProvider) {
        this.checkOpen();
        this.delegate.addUriExtractor(uriExtractorProvider);
    }

    private void checkOpen() {
        if (this.close) {
            throw new IllegalStateException("ProfilerPluginSetupContext already initialized");
        }
    }

    public void close() {
        this.close = true;
    }
}

