/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver.grpc;

import com.navercorp.pinpoint.grpc.trace.PCmdActiveThreadCountRes;
import com.navercorp.pinpoint.grpc.trace.PCmdStreamResponse;
import com.navercorp.pinpoint.profiler.receiver.grpc.GrpcProfilerStreamSocket;
import com.navercorp.pinpoint.profiler.receiver.grpc.GrpcStreamService;
import com.navercorp.pinpoint.profiler.receiver.grpc.PinpointClientResponseObserver;
import io.grpc.stub.ClientResponseObserver;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActiveThreadCountStreamSocket
implements GrpcProfilerStreamSocket<PCmdActiveThreadCountRes.Builder> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final GrpcStreamService grpcStreamService;
    private final int streamObserverId;
    private int sequenceId = 0;
    private final PinpointClientResponseObserver<PCmdActiveThreadCountRes> clientResponseObserver;

    public ActiveThreadCountStreamSocket(int streamObserverId, GrpcStreamService grpcStreamService) {
        this.streamObserverId = streamObserverId;
        this.grpcStreamService = Objects.requireNonNull(grpcStreamService, "grpcStreamService");
        this.clientResponseObserver = new PinpointClientResponseObserver(this);
    }

    @Override
    public void send(PCmdActiveThreadCountRes.Builder sendBuilder) {
        PCmdStreamResponse.Builder headerResponseBuilder = PCmdStreamResponse.newBuilder();
        headerResponseBuilder.setResponseId(this.streamObserverId);
        headerResponseBuilder.setSequenceId(this.getSequenceId());
        sendBuilder.setCommonStreamResponse(headerResponseBuilder.build());
        if (this.clientResponseObserver.isReady()) {
            this.clientResponseObserver.getRequestObserver().onNext((Object)sendBuilder.build());
        }
    }

    private int getSequenceId() {
        return ++this.sequenceId;
    }

    @Override
    public void close() {
        this.logger.info("close");
        this.close0(null);
    }

    @Override
    public void close(Throwable throwable) {
        this.logger.warn("close. message:{}", (Object)throwable.getMessage(), (Object)throwable);
        this.close0(throwable);
    }

    @Override
    public void disconnect() {
        this.logger.info("disconnect");
        this.close0(null);
    }

    @Override
    public void disconnect(Throwable throwable) {
        this.logger.info("disconnect. message:{}", (Object)throwable.getMessage(), (Object)throwable);
        this.close0(throwable);
    }

    private void close0(Throwable throwable) {
        if (this.clientResponseObserver.isReady()) {
            if (throwable == null) {
                this.clientResponseObserver.getRequestObserver().onCompleted();
            } else {
                this.clientResponseObserver.getRequestObserver().onError(throwable);
            }
        }
        this.grpcStreamService.unregister(this);
    }

    @Override
    public ClientResponseObserver getResponseObserver() {
        return this.clientResponseObserver;
    }
}

