/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.sender.MessageSerializer;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializerFactory;
import com.navercorp.pinpoint.thrift.io.TBaseSerializer;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;

public class ThriftMessageSerializer<T>
implements MessageSerializer<T, byte[]> {
    public static final int UDP_MAX_PACKET_LENGTH = 65507;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final TBaseSerializer serializer;
    private final MessageConverter<T, TBase<?, ?>> messageConverter;

    public ThriftMessageSerializer(MessageConverter<T, TBase<?, ?>> messageConverter) {
        this(messageConverter, (TBaseSerializer)HeaderTBaseSerializerFactory.DEFAULT_FACTORY.createSerializer());
    }

    public ThriftMessageSerializer(MessageConverter<T, TBase<?, ?>> messageConverter, TBaseSerializer serializer) {
        this.messageConverter = Objects.requireNonNull(messageConverter, "messageConverter");
        this.serializer = Objects.requireNonNull(serializer, "serializer");
    }

    @Override
    public byte[] serializer(T message) {
        if (message instanceof TBase) {
            TBase tBase = (TBase)message;
            return this.serialize(this.serializer, tBase);
        }
        TBase<?, ?> tBase = this.messageConverter.toMessage(message);
        if (tBase != null) {
            return this.serialize(this.serializer, tBase);
        }
        return null;
    }

    private byte[] serialize(TBaseSerializer serializer, TBase<?, ?> tBase) {
        try {
            return serializer.serialize(tBase);
        }
        catch (TException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Serialize {} failed. Error:{}", tBase, (Object)e.getMessage(), (Object)e);
            }
            return null;
        }
    }
}

