/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.rabbitmq.consumer;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.storage.rabbitmq.client.RabbitmqClient;
import org.apache.eventmesh.storage.rabbitmq.client.RabbitmqConnectionFactory;
import org.apache.eventmesh.storage.rabbitmq.config.ConfigurationHolder;
import org.apache.eventmesh.storage.rabbitmq.consumer.RabbitmqConsumerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Config(field="configurationHolder")
public class RabbitmqConsumer
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(RabbitmqConsumer.class);
    private RabbitmqConnectionFactory rabbitmqConnectionFactory = new RabbitmqConnectionFactory();
    private RabbitmqClient rabbitmqClient;
    private Connection connection;
    private Channel channel;
    private volatile boolean started = false;
    private ConfigurationHolder configurationHolder;
    private final ThreadPoolExecutor executor = ThreadPoolFactory.createThreadPoolExecutor((int)(Runtime.getRuntime().availableProcessors() * 2), (int)(Runtime.getRuntime().availableProcessors() * 2), (String)"EventMesh-Rabbitmq-Consumer");
    private RabbitmqConsumerHandler rabbitmqConsumerHandler;

    public boolean isStarted() {
        return this.started;
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public void start() {
        if (!this.started) {
            this.started = true;
        }
    }

    public void shutdown() {
        if (this.started) {
            try {
                this.rabbitmqClient.closeConnection(this.connection);
                this.rabbitmqClient.closeChannel(this.channel);
                this.rabbitmqConsumerHandler.stop();
            }
            finally {
                this.started = false;
            }
        }
    }

    public void init(Properties keyValue) throws Exception {
        this.rabbitmqClient = new RabbitmqClient(this.rabbitmqConnectionFactory);
        this.connection = this.rabbitmqClient.getConnection(this.configurationHolder.getHost(), this.configurationHolder.getUsername(), this.configurationHolder.getPasswd(), this.configurationHolder.getPort(), this.configurationHolder.getVirtualHost());
        this.channel = this.rabbitmqConnectionFactory.createChannel(this.connection);
        this.rabbitmqConsumerHandler = new RabbitmqConsumerHandler(this.channel, this.configurationHolder);
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
    }

    public void subscribe(String topic) {
        this.rabbitmqClient.binding(this.channel, this.configurationHolder.getExchangeType(), this.configurationHolder.getExchangeName(), this.configurationHolder.getRoutingKey(), this.configurationHolder.getQueueName());
        this.executor.execute(this.rabbitmqConsumerHandler);
    }

    public void unsubscribe(String topic) {
        try {
            this.rabbitmqClient.unbinding(this.channel, this.configurationHolder.getExchangeName(), this.configurationHolder.getRoutingKey(), this.configurationHolder.getQueueName());
            this.rabbitmqConsumerHandler.stop();
        }
        catch (Exception ex) {
            log.error("[RabbitmqConsumer] unsubscribe happen exception.", (Throwable)ex);
        }
    }

    public void registerEventListener(EventListener listener) {
        this.rabbitmqConsumerHandler.setEventListener(listener);
    }

    public void setRabbitmqConnectionFactory(RabbitmqConnectionFactory rabbitmqConnectionFactory) {
        this.rabbitmqConnectionFactory = rabbitmqConnectionFactory;
    }

    public ConfigurationHolder getClientConfiguration() {
        return this.configurationHolder;
    }
}

