/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.config.util;

import com.navercorp.pinpoint.bootstrap.config.ConfigurationException;
import com.navercorp.pinpoint.bootstrap.config.Value;
import com.navercorp.pinpoint.bootstrap.util.spring.PropertyPlaceholderHelper;
import com.navercorp.pinpoint.common.util.ModifierUtils;
import com.navercorp.pinpoint.common.util.logger.CommonLogger;
import com.navercorp.pinpoint.common.util.logger.StdoutCommonLoggerFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class ValueAnnotationProcessor {
    private static final Map<Class<?>, ParameterParser> parameterMap = ValueAnnotationProcessor.newFieldInjectorMap();
    private final PropertyPlaceholderHelper placeHolderParser = new PropertyPlaceholderHelper("${", "}", ":", false);

    private static Map<Class<?>, ParameterParser> newFieldInjectorMap() {
        IdentityHashMap map = new IdentityHashMap();
        ValueAnnotationProcessor.put(map, new StringParameterParser());
        ValueAnnotationProcessor.put(map, new IntegerParameterParser());
        ValueAnnotationProcessor.put(map, new LongParameterParser());
        ValueAnnotationProcessor.put(map, new BooleanParameterParser());
        ValueAnnotationProcessor.put(map, new DoubleParameterParser());
        ValueAnnotationProcessor.put(map, new FloatParameterParser());
        ValueAnnotationProcessor.put(map, new ShortParameterParser());
        ValueAnnotationProcessor.put(map, new ByteParameterParser());
        ValueAnnotationProcessor.put(map, new CharParameterParser());
        return map;
    }

    private static void put(Map<Class<?>, ParameterParser> map, ParameterParser parameterParser) {
        Class<?>[] fieldTypes;
        for (Class<?> fieldType : fieldTypes = parameterParser.getTypes()) {
            map.put(fieldType, parameterParser);
        }
    }

    public void process(Object instance, final Properties properties) throws ConfigurationException {
        Objects.requireNonNull(instance, "instance");
        Objects.requireNonNull(properties, "properties");
        PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver = new PropertyPlaceholderHelper.PlaceholderResolver(){

            @Override
            public String resolvePlaceholder(String placeholderName) {
                return properties.getProperty(placeholderName);
            }
        };
        this.process(instance, placeholderResolver);
    }

    public void process(Object instance, PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver) throws ConfigurationException {
        Objects.requireNonNull(instance, "instance");
        Objects.requireNonNull(placeholderResolver, "placeholderResolver");
        Class<?> aClass = instance.getClass();
        String packageName = aClass.getPackage().getName();
        if (!packageName.startsWith("com.navercorp.pinpoint")) {
            throw new IllegalAccessError("Access violation package:" + packageName);
        }
        this.handleFields(aClass, instance, placeholderResolver);
        this.handleMethods(aClass, instance, placeholderResolver);
    }

    private void handleFields(Class<?> aClass, Object instance, PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver) {
        for (Field field : aClass.getDeclaredFields()) {
            String value = this.getValue(field, placeholderResolver);
            if (value == null) continue;
            this.injectField(field, instance, value);
        }
    }

    private void handleMethods(Class<?> aClass, Object instance, PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver) {
        for (Method method : this.filterMethod(aClass)) {
            String value = this.getValue(method, placeholderResolver);
            if (value == null) continue;
            this.injectMethod(method, instance, value);
        }
    }

    private String getValue(AccessibleObject accessibleObject, PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver) {
        String rawKey = this.getValueFromAnnotation(accessibleObject);
        if (rawKey == null) {
            return null;
        }
        try {
            return this.placeHolderParser.replacePlaceholders(rawKey, placeholderResolver);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private List<Method> filterMethod(Class<?> clazz) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method declaredMethod : clazz.getDeclaredMethods()) {
            if (!this.filterMethod(declaredMethod)) continue;
            list.add(declaredMethod);
        }
        return list;
    }

    private boolean filterMethod(Method method) {
        if (!method.isAnnotationPresent(Value.class)) {
            return false;
        }
        if (!this.checkModifier(method)) {
            return false;
        }
        if (!method.getName().startsWith("set")) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        return parameterTypes.length == 1;
    }

    private boolean checkModifier(Method method) {
        int mod = method.getModifiers();
        if (Modifier.isPublic(mod)) {
            return true;
        }
        return ModifierUtils.isPackage((int)mod);
    }

    private String getValueFromAnnotation(AccessibleObject accessibleObject) {
        Value valueAnnotation = accessibleObject.getAnnotation(Value.class);
        if (valueAnnotation == null) {
            return null;
        }
        return valueAnnotation.value();
    }

    private void setAccessible(AccessibleObject accessibleObject) {
        if (!accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
    }

    private void injectMethod(Method method, Object target, String value) {
        Class<?> parameterType = method.getParameterTypes()[0];
        Object parsedValue = this.parse(parameterType, value);
        if (parsedValue != null) {
            try {
                this.setAccessible(method);
                method.invoke(target, parsedValue);
            }
            catch (ReflectiveOperationException e) {
                throw new ConfigurationException(this.getFieldName(target, method) + " access error", e);
            }
        } else {
            throw new ConfigurationException("unsupported data type :" + this.getFieldName(target, method));
        }
    }

    private Object parse(Class<?> parameterType, String value) {
        if (parameterType.isEnum()) {
            return this.parseEnum(parameterType, value);
        }
        ParameterParser parameterParser = parameterMap.get(parameterType);
        if (parameterParser == null) {
            throw new ConfigurationException("Unsupported type:" + parameterType);
        }
        return parameterParser.parse(value);
    }

    private void injectField(Field field, Object target, String value) {
        block4: {
            Class<?> fieldType = field.getType();
            try {
                Object parsedValue = this.parse(fieldType, value);
                if (parsedValue == null) break block4;
                try {
                    this.setAccessible(field);
                    field.set(target, parsedValue);
                }
                catch (ReflectiveOperationException e) {
                    throw new ConfigurationException(this.getFieldName(target, field) + " access error", e);
                }
            }
            catch (Exception ex) {
                CommonLogger logger = StdoutCommonLoggerFactory.INSTANCE.getLogger(this.getClass().getName());
                logger.warn("injectField error field:" + field + " value:" + value);
                throw new RuntimeException("injectField error", ex);
            }
        }
    }

    private String getFieldName(Object instance, Member field) {
        return instance.getClass().getSimpleName() + "." + field.getName();
    }

    private Object parseEnum(Class<Enum> type, String value) {
        return Enum.valueOf(type, value);
    }

    private static class CharParameterParser
    implements ParameterParser {
        private CharParameterParser() {
        }

        @Override
        public Class<?>[] getTypes() {
            return new Class[]{Character.TYPE, Character.class};
        }

        @Override
        public Object parse(String value) {
            return Character.valueOf(this.parseChar(value));
        }

        private char parseChar(String value) {
            if (value.length() != 1) {
                throw new IllegalArgumentException("Invalid value:" + value);
            }
            return value.charAt(0);
        }
    }

    private static class ByteParameterParser
    implements ParameterParser {
        private ByteParameterParser() {
        }

        @Override
        public Class<?>[] getTypes() {
            return new Class[]{Byte.TYPE, Byte.class};
        }

        @Override
        public Object parse(String value) {
            return Byte.parseByte(value);
        }
    }

    private static class ShortParameterParser
    implements ParameterParser {
        private ShortParameterParser() {
        }

        @Override
        public Class<?>[] getTypes() {
            return new Class[]{Short.TYPE, Short.class};
        }

        @Override
        public Object parse(String value) {
            return Short.parseShort(value);
        }
    }

    private static class FloatParameterParser
    implements ParameterParser {
        private FloatParameterParser() {
        }

        @Override
        public Class<?>[] getTypes() {
            return new Class[]{Float.TYPE, Float.class};
        }

        @Override
        public Object parse(String value) {
            return Float.valueOf(Float.parseFloat(value));
        }
    }

    private static class DoubleParameterParser
    implements ParameterParser {
        private DoubleParameterParser() {
        }

        @Override
        public Class<?>[] getTypes() {
            return new Class[]{Double.TYPE, Double.class};
        }

        @Override
        public Object parse(String value) {
            return Double.parseDouble(value);
        }
    }

    private static class BooleanParameterParser
    implements ParameterParser {
        private BooleanParameterParser() {
        }

        @Override
        public Class<?>[] getTypes() {
            return new Class[]{Boolean.TYPE, Boolean.class};
        }

        @Override
        public Object parse(String value) {
            return Boolean.parseBoolean(value);
        }
    }

    private static class LongParameterParser
    implements ParameterParser {
        private LongParameterParser() {
        }

        @Override
        public Class<?>[] getTypes() {
            return new Class[]{Long.TYPE, Long.class};
        }

        @Override
        public Object parse(String value) {
            return Long.parseLong(value);
        }
    }

    private static class IntegerParameterParser
    implements ParameterParser {
        private IntegerParameterParser() {
        }

        @Override
        public Class<?>[] getTypes() {
            return new Class[]{Integer.TYPE, Integer.class};
        }

        @Override
        public Object parse(String value) {
            return Integer.parseInt(value);
        }
    }

    private static class StringParameterParser
    implements ParameterParser {
        private StringParameterParser() {
        }

        @Override
        public Class<?>[] getTypes() {
            return new Class[]{String.class};
        }

        @Override
        public Object parse(String value) {
            return value;
        }
    }

    public static interface ParameterParser {
        public Class<?>[] getTypes();

        public Object parse(String var1);
    }
}

