/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.transformer;

import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.exception.PinpointException;
import java.lang.reflect.Modifier;
import java.util.Objects;

public final class TransformCallbackChecker {
    private TransformCallbackChecker() {
    }

    public static void validate(Class<? extends TransformCallback> transformCallbackClass) {
        TransformCallbackChecker.validate(transformCallbackClass, null);
    }

    public static void validate(Class<? extends TransformCallback> transformCallbackClass, Class<?>[] parameterTypes) {
        int modifiers;
        Objects.requireNonNull(transformCallbackClass, "transformCallbackClass");
        Class<?> enclosingClass = transformCallbackClass.getEnclosingClass();
        if (enclosingClass != null && !Modifier.isStatic(modifiers = transformCallbackClass.getModifiers())) {
            throw new PinpointException("transformCallbackClass must be static inner class. class:" + transformCallbackClass.getName());
        }
        try {
            transformCallbackClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new PinpointException("constructor not found " + transformCallbackClass.getName(), e);
        }
    }
}

