/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestAdaptor;
import com.navercorp.pinpoint.bootstrap.util.InterceptorUtils;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import java.util.Objects;

public class ClientRequestRecorder<T> {
    private static final String DEFAULT_DESTINATION_ID = "Unknown";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final boolean param;
    private final ClientRequestAdaptor<T> clientRequestAdaptor;

    public ClientRequestRecorder(boolean param, ClientRequestAdaptor<T> clientRequestAdaptor) {
        this.param = param;
        this.clientRequestAdaptor = Objects.requireNonNull(clientRequestAdaptor, "clientRequestAdaptor");
    }

    public void record(SpanEventRecorder recorder, T clientRequest, Throwable throwable) {
        String url;
        if (recorder == null || clientRequest == null) {
            return;
        }
        String destinationId = this.clientRequestAdaptor.getDestinationId(clientRequest);
        if (destinationId != null) {
            recorder.recordDestinationId(destinationId);
            if (this.isDebug) {
                this.logger.debug("Record destinationId={}", (Object)destinationId);
            }
        } else {
            recorder.recordDestinationId(DEFAULT_DESTINATION_ID);
            if (this.isDebug) {
                this.logger.debug("Record destinationId={}", (Object)DEFAULT_DESTINATION_ID);
            }
        }
        if ((url = this.clientRequestAdaptor.getUrl(clientRequest)) != null) {
            String httpUrl = InterceptorUtils.getHttpUrl(url, this.param);
            recorder.recordAttribute(AnnotationKey.HTTP_URL, httpUrl);
            if (this.isDebug) {
                this.logger.debug("Record url={}", (Object)httpUrl);
            }
        }
    }
}

