/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request;

import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.HttpStatusCodeErrors;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.plugin.RequestRecorderFactory;
import com.navercorp.pinpoint.bootstrap.plugin.http.HttpStatusCodeRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.proxy.DisableRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.proxy.ProxyRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.AllServerHeaderRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.BypassServerCookieRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.BypassServerHeaderRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.CookieSupportAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.DefaultServerCookieRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.DefaultServerHeaderRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceReader;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServerCookieRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServerHeaderRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServerRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.ServletRequestListener;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.DisableParameterRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.RemoteAddressResolverFactory;
import com.navercorp.pinpoint.bootstrap.plugin.uri.DisabledUriStatRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.uri.UriStatRecorder;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ServletRequestListenerBuilder<REQ> {
    private final ServiceType serviceType;
    private final TraceContext traceContext;
    private final RequestAdaptor<REQ> requestAdaptor;
    private String realIpHeader;
    private String realIpEmptyValue;
    private ParameterRecorder<REQ> parameterRecorder;
    private Filter<String> excludeUrlFilter;
    private RequestRecorderFactory<REQ> requestRecorderFactory;
    private HttpStatusCodeErrors httpStatusCodeErrors;
    private List<String> recordRequestHeaders;
    private List<String> recordRequestCookies;
    private UriStatRecorder<REQ> uriStatRecorder = DisabledUriStatRecorder.create();
    private boolean recordStatusCode = true;

    public ServletRequestListenerBuilder(ServiceType serviceType, TraceContext traceContext, RequestAdaptor<REQ> requestAdaptor) {
        this.serviceType = Objects.requireNonNull(serviceType, "serviceType");
        this.traceContext = Objects.requireNonNull(traceContext, "traceContext");
        this.requestAdaptor = Objects.requireNonNull(requestAdaptor, "requestAdaptor");
    }

    public void setParameterRecorder(ParameterRecorder<REQ> parameterRecorder) {
        this.parameterRecorder = parameterRecorder;
    }

    public void setRealIpSupport(String realIpHeader, String realIpEmptyValue) {
        this.realIpHeader = realIpHeader;
        this.realIpEmptyValue = realIpEmptyValue;
    }

    public void setExcludeURLFilter(Filter<String> excludeUrlFilter) {
        this.excludeUrlFilter = excludeUrlFilter;
    }

    public void setRequestRecorderFactory(RequestRecorderFactory<REQ> requestRecorderFactory) {
        this.requestRecorderFactory = requestRecorderFactory;
    }

    public void setHttpStatusCodeRecorder(HttpStatusCodeErrors httpStatusCodeErrors) {
        this.httpStatusCodeErrors = httpStatusCodeErrors;
    }

    public void setServerHeaderRecorder(List<String> recordRequestHeaders) {
        this.recordRequestHeaders = recordRequestHeaders;
    }

    public void setServerCookieRecorder(List<String> recordRequestCookies) {
        this.recordRequestCookies = recordRequestCookies;
    }

    public void setReqUriStatRecorder(UriStatRecorder<REQ> reqUriStatRecorder) {
        Objects.requireNonNull(reqUriStatRecorder, "reqUriStatRecorder");
        this.uriStatRecorder = reqUriStatRecorder;
    }

    public void setRecordStatusCode(boolean recordStatusCode) {
        this.recordStatusCode = recordStatusCode;
    }

    private <T> Filter<T> newExcludeUrlFilter(Filter<T> excludeUrlFilter) {
        if (excludeUrlFilter == null) {
            return new SkipFilter();
        }
        return excludeUrlFilter;
    }

    public ServletRequestListener<REQ> build() {
        HttpStatusCodeRecorder httpStatusCodeRecorder;
        RequestAdaptor<REQ> requestAdaptor = RemoteAddressResolverFactory.wrapRealIpSupport(this.requestAdaptor, this.realIpHeader, this.realIpEmptyValue);
        RequestTraceReader<REQ> requestTraceReader = new RequestTraceReader<REQ>(this.traceContext, requestAdaptor, true);
        ProxyRequestRecorder<Object> proxyRequestRecorder = this.requestRecorderFactory == null ? new DisableRequestRecorder() : this.requestRecorderFactory.getProxyRequestRecorder(requestAdaptor);
        Filter<String> excludeUrlFilter = this.newExcludeUrlFilter(this.excludeUrlFilter);
        ServerRequestRecorder<REQ> serverRequestRecorder = this.newServerRequestRecorder(requestAdaptor);
        ParameterRecorder<REQ> parameterRecorder = this.newParameterRecorder();
        if (this.httpStatusCodeErrors == null) {
            HttpStatusCodeErrors httpStatusCodeErrors = new HttpStatusCodeErrors(Collections.emptyList());
            httpStatusCodeRecorder = new HttpStatusCodeRecorder(httpStatusCodeErrors);
        } else {
            httpStatusCodeRecorder = new HttpStatusCodeRecorder(this.httpStatusCodeErrors);
        }
        return new ServletRequestListener<REQ>(this.serviceType, this.traceContext, requestAdaptor, requestTraceReader, excludeUrlFilter, parameterRecorder, proxyRequestRecorder, serverRequestRecorder, httpStatusCodeRecorder, this.uriStatRecorder, this.recordStatusCode);
    }

    private ServerRequestRecorder<REQ> newServerRequestRecorder(RequestAdaptor<REQ> requestAdaptor) {
        ServerHeaderRecorder<REQ> headerRecorder = this.newServerHeaderRecorder(requestAdaptor);
        ServerCookieRecorder<REQ> cookieRecorder = this.newServerCookieRecorder(requestAdaptor);
        return new ServerRequestRecorder<REQ>(requestAdaptor, headerRecorder, cookieRecorder);
    }

    private ServerHeaderRecorder<REQ> newServerHeaderRecorder(RequestAdaptor<REQ> requestAdaptor) {
        if (CollectionUtils.isEmpty(this.recordRequestHeaders)) {
            return new BypassServerHeaderRecorder();
        }
        if (AllServerHeaderRecorder.isRecordAllHeaders(this.recordRequestHeaders)) {
            return new AllServerHeaderRecorder<REQ>(requestAdaptor);
        }
        return new DefaultServerHeaderRecorder<REQ>(requestAdaptor, this.recordRequestHeaders);
    }

    private ServerCookieRecorder<REQ> newServerCookieRecorder(RequestAdaptor<REQ> requestAdaptor) {
        if (CollectionUtils.isEmpty(this.recordRequestCookies)) {
            return new BypassServerCookieRecorder();
        }
        if (!(requestAdaptor instanceof CookieSupportAdaptor)) {
            return new BypassServerCookieRecorder();
        }
        CookieSupportAdaptor cookieAdaptor = (CookieSupportAdaptor)((Object)requestAdaptor);
        return new DefaultServerCookieRecorder(cookieAdaptor, this.recordRequestCookies);
    }

    private ParameterRecorder<REQ> newParameterRecorder() {
        if (this.parameterRecorder == null) {
            return new DisableParameterRecorder();
        }
        return this.parameterRecorder;
    }
}

