/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.response;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.http.HttpStatusCodeRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.response.ServerResponseHeaderRecorder;
import com.navercorp.pinpoint.common.trace.ServiceType;
import java.util.Objects;

public class ServletResponseListener<RESP> {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final ServerResponseHeaderRecorder<RESP> serverResponseHeaderRecorder;
    private final HttpStatusCodeRecorder httpStatusCodeRecorder;

    public ServletResponseListener(TraceContext traceContext, ServerResponseHeaderRecorder<RESP> serverResponseHeaderRecorder, HttpStatusCodeRecorder httpStatusCodeRecorder) {
        this.traceContext = Objects.requireNonNull(traceContext, "traceContext");
        this.serverResponseHeaderRecorder = Objects.requireNonNull(serverResponseHeaderRecorder, "serverResponseHeaderRecorder");
        this.httpStatusCodeRecorder = Objects.requireNonNull(httpStatusCodeRecorder, "statusCodeRecorder");
    }

    public void initialized(RESP response, ServiceType serviceType, MethodDescriptor methodDescriptor) {
        Objects.requireNonNull(response, "response");
        Objects.requireNonNull(serviceType, "serviceType");
        Objects.requireNonNull(methodDescriptor, "methodDescriptor");
        if (this.isDebug) {
            this.logger.debug("Initialized responseEvent. response={}, serviceType={}, methodDescriptor={}", response, serviceType, methodDescriptor);
        }
    }

    public void destroyed(RESP response, Throwable throwable, int statusCode) {
        Trace trace;
        Objects.requireNonNull(response, "response");
        if (this.isDebug) {
            this.logger.debug("Destroyed responseEvent. response={}, throwable={}, statusCode={}", response, throwable, statusCode);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        if (trace.canSampled()) {
            SpanRecorder spanRecorder = trace.getSpanRecorder();
            this.httpStatusCodeRecorder.record(spanRecorder, statusCode);
            this.serverResponseHeaderRecorder.recordHeader(spanRecorder, response);
        }
    }
}

