/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.response;

import com.navercorp.pinpoint.bootstrap.config.HttpStatusCodeErrors;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.plugin.http.HttpStatusCodeRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.response.BypassServerResponseHeaderRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.response.DefaultServerResponseHeaderRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.response.ResponseAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.response.ServerResponseHeaderRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.response.ServletResponseListener;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ServletResponseListenerBuilder<RESP> {
    private final TraceContext traceContext;
    private final ResponseAdaptor<RESP> responseAdaptor;
    private List<String> recordResponseHeaders;
    private HttpStatusCodeErrors httpStatusCodeErrors;

    public ServletResponseListenerBuilder(TraceContext traceContext, ResponseAdaptor<RESP> responseAdaptor) {
        this.traceContext = Objects.requireNonNull(traceContext, "traceContext");
        this.responseAdaptor = Objects.requireNonNull(responseAdaptor, "responseAdaptor");
        ProfilerConfig profilerConfig = traceContext.getProfilerConfig();
        List<String> recordResponseHeaders = profilerConfig.readList("profiler.http.record.response.headers");
        this.setRecordResponseHeaders(recordResponseHeaders);
        this.setHttpStatusCodeRecorder(profilerConfig.getHttpStatusCodeErrors());
    }

    public void setRecordResponseHeaders(List<String> recordResponseHeaders) {
        this.recordResponseHeaders = recordResponseHeaders;
    }

    public void setHttpStatusCodeRecorder(HttpStatusCodeErrors httpStatusCodeErrors) {
        this.httpStatusCodeErrors = httpStatusCodeErrors;
    }

    public ServletResponseListener<RESP> build() {
        HttpStatusCodeRecorder httpStatusCodeRecorder;
        if (this.httpStatusCodeErrors == null) {
            HttpStatusCodeErrors httpStatusCodeErrors = new HttpStatusCodeErrors(Collections.emptyList());
            httpStatusCodeRecorder = new HttpStatusCodeRecorder(httpStatusCodeErrors);
        } else {
            httpStatusCodeRecorder = new HttpStatusCodeRecorder(this.httpStatusCodeErrors);
        }
        return new ServletResponseListener<RESP>(this.traceContext, this.newServerResponseHeaderRecorder(), httpStatusCodeRecorder);
    }

    private ServerResponseHeaderRecorder<RESP> newServerResponseHeaderRecorder() {
        if (CollectionUtils.isEmpty(this.recordResponseHeaders)) {
            return new BypassServerResponseHeaderRecorder();
        }
        return new DefaultServerResponseHeaderRecorder<RESP>(this.responseAdaptor, this.recordResponseHeaders);
    }
}

