/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.rocketmq.source.connector;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.eventmesh.connector.rocketmq.source.config.RocketMQSourceConfig;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.api.data.RecordOffset;
import org.apache.eventmesh.openconnect.api.data.RecordPartition;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.rocketmq.client.consumer.DefaultLitePullConsumer;
import org.apache.rocketmq.common.message.MessageExt;

public class RocketMQSourceConnector
implements Source {
    private RocketMQSourceConfig sourceConfig;
    private final DefaultLitePullConsumer consumer = new DefaultLitePullConsumer();

    public Class<? extends Config> configClass() {
        return RocketMQSourceConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sourceConfig = (RocketMQSourceConfig)config;
        this.consumer.setConsumerGroup(this.sourceConfig.getPubSubConfig().getGroup());
        this.consumer.setNamesrvAddr(this.sourceConfig.getConnectorConfig().getNameserver());
    }

    public void start() throws Exception {
        this.consumer.subscribe(this.sourceConfig.getConnectorConfig().getTopic(), "*");
        this.consumer.start();
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void stop() {
        this.consumer.unsubscribe(this.sourceConfig.getConnectorConfig().getTopic());
        this.consumer.shutdown();
    }

    public List<ConnectRecord> poll() {
        List messageExts = this.consumer.poll();
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(messageExts.size());
        for (MessageExt messageExt : messageExts) {
            Long timestamp = System.currentTimeMillis();
            byte[] body = messageExt.getBody();
            String bodyStr = new String(body, StandardCharsets.UTF_8);
            RecordPartition recordPartition = RocketMQSourceConnector.convertToRecordPartition(messageExt.getTopic(), messageExt.getBrokerName(), messageExt.getQueueId());
            RecordOffset recordOffset = RocketMQSourceConnector.convertToRecordOffset(messageExt.getQueueOffset());
            ConnectRecord connectRecord = new ConnectRecord(recordPartition, recordOffset, timestamp, (Object)bodyStr);
            connectRecord.addExtension("topic", messageExt.getTopic());
            connectRecords.add(connectRecord);
        }
        return connectRecords;
    }

    public static RecordOffset convertToRecordOffset(Long offset) {
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        offsetMap.put("queueOffset", offset + "");
        return new RecordOffset(offsetMap);
    }

    public static RecordPartition convertToRecordPartition(String topic, String brokerName, int queueId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("topic", topic);
        map.put("brokerName", brokerName);
        map.put("queueId", queueId + "");
        return new RecordPartition(map);
    }
}

