/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractMapSizeAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.api.EnumerableAssert;
import org.assertj.core.api.MapSizeAssert;
import org.assertj.core.data.MapEntry;
import org.assertj.core.description.Description;
import org.assertj.core.internal.Maps;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractMapAssert<S extends AbstractMapAssert<S, A, K, V>, A extends Map<K, V>, K, V>
extends AbstractAssert<S, A>
implements EnumerableAssert<S, Map.Entry<? extends K, ? extends V>> {
    @VisibleForTesting
    Maps maps = Maps.instance();

    public AbstractMapAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.maps.assertNullOrEmpty(this.info, (Map)this.actual);
    }

    @Override
    public void isEmpty() {
        this.maps.assertEmpty(this.info, (Map)this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.maps.assertNotEmpty(this.info, (Map)this.actual);
        return (S)((AbstractMapAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.maps.assertHasSize(this.info, (Map)this.actual, expected);
        return (S)((AbstractMapAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Object other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (S)((AbstractMapAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S hasSameSizeAs(Map<?, ?> other) {
        this.maps.assertHasSameSizeAs((AssertionInfo)this.info, (Map)this.actual, other);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S contains(Map.Entry<? extends K, ? extends V> ... entries) {
        this.maps.assertContains(this.info, (Map)this.actual, entries);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsAnyOf(Map.Entry<? extends K, ? extends V> ... entries) {
        this.maps.assertContainsAnyOf(this.info, (Map)this.actual, entries);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsAllEntriesOf(Map<? extends K, ? extends V> other) {
        Map.Entry[] entries = other.entrySet().toArray(new Map.Entry[other.size()]);
        this.maps.assertContains(this.info, (Map)this.actual, entries);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsEntry(K key, V value) {
        this.maps.assertContains(this.info, (Map)this.actual, Arrays.array(MapEntry.entry(key, value)));
        return (S)((AbstractMapAssert)this.myself);
    }

    public S hasEntrySatisfying(K key, Condition<? super V> valueCondition) {
        this.maps.assertHasEntrySatisfying(this.info, (Map)this.actual, key, valueCondition);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S doesNotContain(Map.Entry<? extends K, ? extends V> ... entries) {
        this.maps.assertDoesNotContain(this.info, (Map)this.actual, entries);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S doesNotContainEntry(K key, V value) {
        this.maps.assertDoesNotContain(this.info, (Map)this.actual, Arrays.array(MapEntry.entry(key, value)));
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsKey(K key) {
        return this.containsKeys(key);
    }

    public S containsKeys(K ... keys) {
        this.maps.assertContainsKeys(this.info, (Map)this.actual, keys);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S doesNotContainKey(K key) {
        return this.doesNotContainKeys(key);
    }

    public S doesNotContainKeys(K ... keys) {
        this.maps.assertDoesNotContainKeys(this.info, (Map)this.actual, keys);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsOnlyKeys(K ... keys) {
        this.maps.assertContainsOnlyKeys(this.info, (Map)this.actual, keys);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsValue(V value) {
        this.maps.assertContainsValue(this.info, (Map)this.actual, value);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsValues(V ... values) {
        this.maps.assertContainsValues(this.info, (Map)this.actual, values);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S doesNotContainValue(V value) {
        this.maps.assertDoesNotContainValue(this.info, (Map)this.actual, value);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsOnly(Map.Entry<? extends K, ? extends V> ... entries) {
        this.maps.assertContainsOnly(this.info, (Map)this.actual, entries);
        return (S)((AbstractMapAssert)this.myself);
    }

    public S containsExactly(Map.Entry<? extends K, ? extends V> ... entries) {
        this.maps.assertContainsExactly(this.info, (Map)this.actual, entries);
        return (S)((AbstractMapAssert)this.myself);
    }

    @Override
    @Deprecated
    public S usingElementComparator(Comparator<? super Map.Entry<? extends K, ? extends V>> customComparator) {
        throw new UnsupportedOperationException("custom element Comparator is not supported for MapEntry comparison");
    }

    @Override
    @Deprecated
    public S usingDefaultElementComparator() {
        throw new UnsupportedOperationException("custom element Comparator is not supported for MapEntry comparison");
    }

    @Override
    public S as(String description, Object ... args) {
        return (S)((AbstractMapAssert)super.as(description, args));
    }

    @Override
    public S as(Description description) {
        return (S)((AbstractMapAssert)super.as(description));
    }

    @Override
    public S describedAs(Description description) {
        return (S)((AbstractMapAssert)super.describedAs(description));
    }

    @Override
    public S describedAs(String description, Object ... args) {
        return (S)((AbstractMapAssert)super.describedAs(description, args));
    }

    @Override
    public S doesNotHave(Condition<? super A> condition) {
        return (S)((AbstractMapAssert)super.doesNotHave((Condition)condition));
    }

    @Override
    public S doesNotHaveSameClassAs(Object other) {
        return (S)((AbstractMapAssert)super.doesNotHaveSameClassAs(other));
    }

    @Override
    public S has(Condition<? super A> condition) {
        return (S)((AbstractMapAssert)super.has((Condition)condition));
    }

    @Override
    public S hasSameClassAs(Object other) {
        return (S)((AbstractMapAssert)super.hasSameClassAs(other));
    }

    @Override
    public S hasToString(String expectedToString) {
        return (S)((AbstractMapAssert)super.hasToString(expectedToString));
    }

    @Override
    public S is(Condition<? super A> condition) {
        return (S)((AbstractMapAssert)super.is((Condition)condition));
    }

    @Override
    public S isEqualTo(Object expected) {
        return (S)((AbstractMapAssert)super.isEqualTo(expected));
    }

    @Override
    public S isExactlyInstanceOf(Class<?> type) {
        return (S)((AbstractMapAssert)super.isExactlyInstanceOf((Class)type));
    }

    @Override
    public S isIn(Iterable<?> values) {
        return (S)((AbstractMapAssert)super.isIn((Iterable)values));
    }

    @Override
    public S isIn(Object ... values) {
        return (S)((AbstractMapAssert)super.isIn(values));
    }

    @Override
    public S isInstanceOf(Class<?> type) {
        return (S)((AbstractMapAssert)super.isInstanceOf((Class)type));
    }

    @Override
    public S isInstanceOfAny(Class<?> ... types) {
        return (S)((AbstractMapAssert)super.isInstanceOfAny((Class[])types));
    }

    @Override
    public S isNot(Condition<? super A> condition) {
        return (S)((AbstractMapAssert)super.isNot((Condition)condition));
    }

    @Override
    public S isNotEqualTo(Object other) {
        return (S)((AbstractMapAssert)super.isNotEqualTo(other));
    }

    @Override
    public S isNotExactlyInstanceOf(Class<?> type) {
        return (S)((AbstractMapAssert)super.isNotExactlyInstanceOf((Class)type));
    }

    @Override
    public S isNotIn(Iterable<?> values) {
        return (S)((AbstractMapAssert)super.isNotIn((Iterable)values));
    }

    @Override
    public S isNotIn(Object ... values) {
        return (S)((AbstractMapAssert)super.isNotIn(values));
    }

    @Override
    public S isNotInstanceOf(Class<?> type) {
        return (S)((AbstractMapAssert)super.isNotInstanceOf((Class)type));
    }

    @Override
    public S isNotInstanceOfAny(Class<?> ... types) {
        return (S)((AbstractMapAssert)super.isNotInstanceOfAny((Class[])types));
    }

    @Override
    public S isNotOfAnyClassIn(Class<?> ... types) {
        return (S)((AbstractMapAssert)super.isNotOfAnyClassIn((Class[])types));
    }

    @Override
    public S isNotNull() {
        return (S)((AbstractMapAssert)super.isNotNull());
    }

    @Override
    public S isNotSameAs(Object other) {
        return (S)((AbstractMapAssert)super.isNotSameAs(other));
    }

    @Override
    public S isOfAnyClassIn(Class<?> ... types) {
        return (S)((AbstractMapAssert)super.isOfAnyClassIn((Class[])types));
    }

    @Override
    public S isSameAs(Object expected) {
        return (S)((AbstractMapAssert)super.isSameAs(expected));
    }

    @Override
    public S overridingErrorMessage(String newErrorMessage, Object ... args) {
        return (S)((AbstractMapAssert)super.overridingErrorMessage(newErrorMessage, args));
    }

    @Override
    public S usingDefaultComparator() {
        return (S)((AbstractMapAssert)super.usingDefaultComparator());
    }

    @Override
    public S usingComparator(Comparator<? super A> customComparator) {
        return (S)((AbstractMapAssert)super.usingComparator((Comparator)customComparator));
    }

    @Override
    public S withFailMessage(String newErrorMessage, Object ... args) {
        return (S)((AbstractMapAssert)super.withFailMessage(newErrorMessage, args));
    }

    @Override
    public S withThreadDumpOnError() {
        return (S)((AbstractMapAssert)super.withThreadDumpOnError());
    }

    public AbstractMapSizeAssert<S, A, K, V> size() {
        Preconditions.checkNotNull(this.actual, "Can not perform assertions on the size of a null map.");
        return new MapSizeAssert(this, ((Map)this.actual).size());
    }
}

