/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.redisson.RedissonQueue;
import org.redisson.api.RDeque;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.api.queue.DequeMoveArgs;
import org.redisson.api.queue.DequeMoveParams;
import org.redisson.api.queue.DequeMoveSource;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListFirstObjectDecoder;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonDeque<V>
extends RedissonQueue<V>
implements RDeque<V> {
    private static final RedisCommand<Object> LRANGE_SINGLE = new RedisCommand<Object>("LRANGE", new ListFirstObjectDecoder());

    public RedissonDeque(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
    }

    public RedissonDeque(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
    }

    @Override
    public int addFirstIfExists(V ... elements) {
        return this.get(this.addFirstIfExistsAsync(elements));
    }

    @Override
    public int addLastIfExists(V ... elements) {
        return this.get(this.addLastIfExistsAsync(elements));
    }

    @Override
    public int addFirst(V ... elements) {
        return (Integer)((Object)this.get(this.addFirstAsync((V)elements)));
    }

    @Override
    public int addLast(V ... elements) {
        return (Integer)((Object)this.get(this.addLastAsync((V)elements)));
    }

    @Override
    public RFuture<Integer> addFirstAsync(V ... elements) {
        ArrayList<Object> args = new ArrayList<Object>(elements.length + 1);
        args.add(this.getRawName());
        this.encode(args, Arrays.asList(elements));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.LPUSH, args.toArray());
    }

    @Override
    public RFuture<Integer> addLastAsync(V ... elements) {
        ArrayList<Object> args = new ArrayList<Object>(elements.length + 1);
        args.add(this.getRawName());
        this.encode(args, Arrays.asList(elements));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.RPUSH, args.toArray());
    }

    @Override
    public RFuture<Integer> addFirstIfExistsAsync(V ... elements) {
        ArrayList<Object> args = new ArrayList<Object>(elements.length + 1);
        args.add(this.getRawName());
        this.encode(args, Arrays.asList(elements));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.LPUSHX, args.toArray());
    }

    @Override
    public RFuture<Integer> addLastIfExistsAsync(V ... elements) {
        ArrayList<Object> args = new ArrayList<Object>(elements.length + 1);
        args.add(this.getRawName());
        this.encode(args, Arrays.asList(elements));
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.RPUSHX, args.toArray());
    }

    @Override
    public void addFirst(V e) {
        this.get(this.addFirstAsync(e));
    }

    @Override
    public RFuture<Void> addFirstAsync(V e) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.LPUSH_VOID, this.getRawName(), this.encode((Object)e));
    }

    @Override
    public void addLast(V e) {
        this.get(this.addLastAsync(e));
    }

    @Override
    public RFuture<Void> addLastAsync(V e) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.RPUSH_VOID, this.getRawName(), this.encode((Object)e));
    }

    @Override
    public V move(DequeMoveArgs args) {
        return this.get(this.moveAsync(args));
    }

    @Override
    public RFuture<V> moveAsync(DequeMoveArgs args) {
        DequeMoveSource source = (DequeMoveSource)((Object)args);
        DequeMoveParams pp = source.getParams();
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.LMOVE, new Object[]{this.getRawName(), pp.getDestName(), pp.getSourceDirection(), pp.getDestDirection()});
    }

    @Override
    public Iterator<V> descendingIterator() {
        return new Iterator<V>(){
            private int currentIndex;
            private boolean removeExecuted;
            {
                this.currentIndex = RedissonDeque.this.size();
            }

            @Override
            public boolean hasNext() {
                int size = RedissonDeque.this.size();
                return this.currentIndex > 0 && size > 0;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                --this.currentIndex;
                this.removeExecuted = false;
                return RedissonDeque.this.get(this.currentIndex);
            }

            @Override
            public void remove() {
                if (this.removeExecuted) {
                    throw new IllegalStateException("Element been already deleted");
                }
                RedissonDeque.this.remove(this.currentIndex);
                ++this.currentIndex;
                this.removeExecuted = true;
            }
        };
    }

    @Override
    public RFuture<V> getLastAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, LRANGE_SINGLE, this.getRawName(), -1, -1);
    }

    @Override
    public V getLast() {
        V result = this.get(this.getLastAsync());
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public boolean offerFirst(V e) {
        return this.get(this.offerFirstAsync(e));
    }

    @Override
    public RFuture<Boolean> offerFirstAsync(V e) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.LPUSH_BOOLEAN, this.getRawName(), this.encode((Object)e));
    }

    @Override
    public RFuture<Boolean> offerLastAsync(V e) {
        return this.offerAsync(e);
    }

    @Override
    public boolean offerLast(V e) {
        return this.get(this.offerLastAsync(e));
    }

    @Override
    public RFuture<V> peekFirstAsync() {
        return this.getAsync(0);
    }

    @Override
    public V peekFirst() {
        return this.get(this.peekFirstAsync());
    }

    @Override
    public RFuture<V> peekLastAsync() {
        return this.getLastAsync();
    }

    @Override
    public V peekLast() {
        return this.get(this.getLastAsync());
    }

    @Override
    public RFuture<V> pollFirstAsync() {
        return this.pollAsync();
    }

    @Override
    public V pollFirst() {
        return this.poll();
    }

    @Override
    public RFuture<List<V>> pollFirstAsync(int limit) {
        return this.pollAsync(limit);
    }

    @Override
    public List<V> pollFirst(int limit) {
        return this.poll(limit);
    }

    @Override
    public RFuture<V> pollLastAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.RPOP, this.getRawName());
    }

    @Override
    public List<V> pollLast(int limit) {
        return this.get(this.pollLastAsync(limit));
    }

    @Override
    public RFuture<List<V>> pollLastAsync(int limit) {
        return this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), this.codec, RedisCommands.EVAL_LIST, "local result = {};for i = 1, ARGV[1], 1 do local value = redis.call('rpop', KEYS[1]);if value ~= false then table.insert(result, value);else return result;end;end; return result;", Collections.singletonList(this.getRawName()), limit);
    }

    @Override
    public V pollLast() {
        return this.get(this.pollLastAsync());
    }

    @Override
    public RFuture<V> popAsync() {
        return this.pollAsync();
    }

    @Override
    public V pop() {
        return this.removeFirst();
    }

    @Override
    public RFuture<Void> pushAsync(V e) {
        return this.addFirstAsync(e);
    }

    @Override
    public void push(V e) {
        this.addFirst(e);
    }

    @Override
    public RFuture<Boolean> removeFirstOccurrenceAsync(Object o) {
        return this.removeAsync(o, 1);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o, 1);
    }

    @Override
    public RFuture<V> removeFirstAsync() {
        return this.pollAsync();
    }

    @Override
    public RFuture<V> removeLastAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.RPOP, this.getRawName());
    }

    @Override
    public V removeLast() {
        V value = this.get(this.removeLastAsync());
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public RFuture<Boolean> removeLastOccurrenceAsync(Object o) {
        return this.removeAsync(o, -1);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.remove(o, -1);
    }
}

