/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.redisson.api.RFuture;
import org.redisson.api.RScript;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonScript
implements RScript {
    private final Codec codec;
    private final CommandAsyncExecutor commandExecutor;

    public RedissonScript(CommandAsyncExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
        this.codec = commandExecutor.getConnectionManager().getCodec();
    }

    public RedissonScript(CommandAsyncExecutor commandExecutor, Codec codec) {
        this.commandExecutor = commandExecutor;
        this.codec = codec;
    }

    @Override
    public String scriptLoad(String luaScript) {
        return this.commandExecutor.get(this.scriptLoadAsync(luaScript));
    }

    public String scriptLoad(String key, String luaScript) {
        return this.commandExecutor.get(this.scriptLoadAsync(key, luaScript));
    }

    @Override
    public RFuture<String> scriptLoadAsync(String luaScript) {
        List futures = this.commandExecutor.executeAllAsync(RedisCommands.SCRIPT_LOAD, luaScript);
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletionStage s = f.thenApply(r -> ((CompletableFuture)futures.get(0)).getNow(null));
        return new CompletableFutureWrapper<String>((CompletableFuture<String>)s);
    }

    @Override
    public RFuture<String> scriptLoadAsync(String key, String luaScript) {
        return this.commandExecutor.writeAsync(key, (Codec)StringCodec.INSTANCE, RedisCommands.SCRIPT_LOAD, luaScript);
    }

    @Override
    public <R> R eval(RScript.Mode mode, String luaScript, RScript.ReturnType returnType) {
        return this.eval(mode, luaScript, returnType, Collections.emptyList(), new Object[0]);
    }

    @Override
    public <R> R eval(RScript.Mode mode, String luaScript, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        String key = null;
        if (!keys.isEmpty()) {
            key = (String)keys.get(0);
        }
        return this.eval(key, mode, luaScript, returnType, keys, values);
    }

    @Override
    public <R> RFuture<R> evalAsync(RScript.Mode mode, String luaScript, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        String key = null;
        if (!keys.isEmpty()) {
            key = (String)keys.get(0);
        }
        return this.evalAsync(key, mode, luaScript, returnType, keys, values);
    }

    @Override
    public <R> R evalSha(RScript.Mode mode, String shaDigest, RScript.ReturnType returnType) {
        return this.evalSha(null, mode, shaDigest, returnType, Collections.emptyList(), new Object[0]);
    }

    @Override
    public <R> R evalSha(RScript.Mode mode, String shaDigest, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.evalSha(null, mode, shaDigest, returnType, keys, values);
    }

    @Override
    public <R> RFuture<R> evalShaAsync(RScript.Mode mode, String shaDigest, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.evalShaAsync(null, mode, this.codec, shaDigest, returnType, keys, values);
    }

    public <R> RFuture<R> evalShaAsync(String key, RScript.Mode mode, Codec codec, String shaDigest, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        RedissonScript script = new RedissonScript(this.commandExecutor, codec);
        return script.evalShaAsync(key, mode, shaDigest, returnType, keys, values);
    }

    @Override
    public void scriptKill() {
        this.commandExecutor.get(this.scriptKillAsync());
    }

    public void scriptKill(String key) {
        this.commandExecutor.get(this.scriptKillAsync(key));
    }

    @Override
    public RFuture<Void> scriptKillAsync() {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.SCRIPT_KILL, new Object[0]);
    }

    public RFuture<Void> scriptKillAsync(String key) {
        return this.commandExecutor.writeAsync(key, RedisCommands.SCRIPT_KILL, new Object[0]);
    }

    @Override
    public List<Boolean> scriptExists(String ... shaDigests) {
        return this.commandExecutor.get(this.scriptExistsAsync(shaDigests));
    }

    @Override
    public RFuture<List<Boolean>> scriptExistsAsync(String ... shaDigests) {
        List futures = this.commandExecutor.executeAllAsync(RedisCommands.SCRIPT_EXISTS, shaDigests);
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletionStage s = f.thenApply(r -> {
            List result = ((CompletableFuture)futures.get(0)).getNow(new ArrayList());
            for (CompletableFuture future : futures.subList(1, futures.size())) {
                List l = future.getNow(new ArrayList());
                for (int i = 0; i < l.size(); ++i) {
                    result.set(i, (Boolean)result.get(i) | (Boolean)l.get(i));
                }
            }
            return result;
        });
        return new CompletableFutureWrapper<List<Boolean>>((CompletableFuture<List<Boolean>>)s);
    }

    public List<Boolean> scriptExists(String key, String ... shaDigests) {
        return this.commandExecutor.get(this.scriptExistsAsync(key, shaDigests));
    }

    @Override
    public RFuture<List<Boolean>> scriptExistsAsync(String key, String ... shaDigests) {
        return this.commandExecutor.writeAsync(key, RedisCommands.SCRIPT_EXISTS, shaDigests);
    }

    @Override
    public void scriptFlush() {
        this.commandExecutor.get(this.scriptFlushAsync());
    }

    public void scriptFlush(String key) {
        this.commandExecutor.get(this.scriptFlushAsync(key));
    }

    @Override
    public RFuture<Void> scriptFlushAsync() {
        return this.commandExecutor.writeAllVoidAsync(RedisCommands.SCRIPT_FLUSH, new Object[0]);
    }

    public RFuture<Void> scriptFlushAsync(String key) {
        return this.commandExecutor.writeAsync(key, RedisCommands.SCRIPT_FLUSH, new Object[0]);
    }

    @Override
    public <R> RFuture<R> evalShaAsync(RScript.Mode mode, String shaDigest, RScript.ReturnType returnType) {
        return this.evalShaAsync(null, mode, this.codec, shaDigest, returnType, Collections.emptyList(), new Object[0]);
    }

    @Override
    public <R> RFuture<R> evalAsync(RScript.Mode mode, String luaScript, RScript.ReturnType returnType) {
        return this.evalAsync(null, mode, luaScript, returnType, Collections.emptyList(), new Object[0]);
    }

    private List<Object> encode(Collection<?> values, Codec codec) {
        ArrayList<Object> result = new ArrayList<Object>(values.size());
        for (Object object : values) {
            result.add(this.commandExecutor.encode(codec, object));
        }
        return result;
    }

    @Override
    public <R> RFuture<R> evalShaAsync(String key, RScript.Mode mode, String shaDigest, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        RedisCommand command = new RedisCommand(returnType.getCommand(), "EVALSHA");
        if (mode == RScript.Mode.READ_ONLY && this.commandExecutor.isEvalShaROSupported()) {
            RedisCommand cmd = new RedisCommand(returnType.getCommand(), "EVALSHA_RO");
            RFuture f = this.commandExecutor.evalReadAsync(key, this.codec, cmd, shaDigest, keys, this.encode(Arrays.asList(values), this.codec).toArray());
            CompletableFuture result = new CompletableFuture();
            f.whenComplete((r, e) -> {
                if (e != null && e.getMessage().startsWith("ERR unknown command")) {
                    this.commandExecutor.setEvalShaROSupported(false);
                    RFuture s = this.evalShaAsync(key, mode, shaDigest, returnType, keys, values);
                    this.commandExecutor.transfer(s.toCompletableFuture(), result);
                    return;
                }
                this.commandExecutor.transfer(f.toCompletableFuture(), result);
            });
            return new CompletableFutureWrapper(result);
        }
        return this.commandExecutor.evalWriteAsync(key, this.codec, command, shaDigest, keys, this.encode(Arrays.asList(values), this.codec).toArray());
    }

    @Override
    public <R> RFuture<R> evalAsync(String key, RScript.Mode mode, String luaScript, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        if (mode == RScript.Mode.READ_ONLY) {
            return this.commandExecutor.evalReadAsync(key, this.codec, returnType.getCommand(), luaScript, keys, this.encode(Arrays.asList(values), this.codec).toArray());
        }
        return this.commandExecutor.evalWriteAsync(key, this.codec, returnType.getCommand(), luaScript, keys, this.encode(Arrays.asList(values), this.codec).toArray());
    }

    @Override
    public <R> R evalSha(String key, RScript.Mode mode, String shaDigest, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.commandExecutor.get(this.evalShaAsync(key, mode, shaDigest, returnType, keys, values));
    }

    @Override
    public <R> R eval(String key, RScript.Mode mode, String luaScript, RScript.ReturnType returnType, List<Object> keys, Object ... values) {
        return this.commandExecutor.get(this.evalAsync(key, mode, luaScript, returnType, keys, values));
    }
}

