/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.redisson.RedissonBucket;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.DeleteOperation;
import org.redisson.transaction.operation.TouchOperation;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.UnlinkOperation;
import org.redisson.transaction.operation.bucket.BucketCompareAndSetOperation;
import org.redisson.transaction.operation.bucket.BucketGetAndDeleteOperation;
import org.redisson.transaction.operation.bucket.BucketGetAndSetOperation;
import org.redisson.transaction.operation.bucket.BucketSetOperation;
import org.redisson.transaction.operation.bucket.BucketTrySetOperation;

public class RedissonTransactionalBucket<V>
extends RedissonBucket<V> {
    static final Object NULL = new Object();
    private long timeout;
    private final AtomicBoolean executed;
    private final List<TransactionalOperation> operations;
    private Object state;
    private final String transactionId;

    public RedissonTransactionalBucket(CommandAsyncExecutor commandExecutor, long timeout, String name, List<TransactionalOperation> operations, AtomicBoolean executed, String transactionId) {
        super(commandExecutor, name);
        this.operations = operations;
        this.executed = executed;
        this.transactionId = transactionId;
        this.timeout = timeout;
    }

    public RedissonTransactionalBucket(Codec codec, CommandAsyncExecutor commandExecutor, long timeout, String name, List<TransactionalOperation> operations, AtomicBoolean executed, String transactionId) {
        super(codec, commandExecutor, name);
        this.operations = operations;
        this.executed = executed;
        this.transactionId = transactionId;
        this.timeout = timeout;
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        throw new UnsupportedOperationException("clearExpire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> moveAsync(int database) {
        throw new UnsupportedOperationException("moveAsync method is not supported in transaction");
    }

    @Override
    public RFuture<Void> migrateAsync(String host, int port, int database, long timeout) {
        throw new UnsupportedOperationException("migrateAsync method is not supported in transaction");
    }

    @Override
    public RFuture<Long> sizeAsync() {
        this.checkState();
        if (this.state != null) {
            if (this.state == NULL) {
                return new CompletableFutureWrapper<Long>(0L);
            }
            ByteBuf buf = this.encode(this.state);
            long size = buf.readableBytes();
            buf.release();
            return new CompletableFutureWrapper<Long>(size);
        }
        return super.sizeAsync();
    }

    @Override
    public RFuture<Boolean> isExistsAsync() {
        this.checkState();
        if (this.state != null) {
            if (this.state == NULL) {
                return new CompletableFutureWrapper<Boolean>((Boolean)null);
            }
            return new CompletableFutureWrapper<Boolean>(true);
        }
        return super.isExistsAsync();
    }

    @Override
    public RFuture<Boolean> touchAsync() {
        this.checkState();
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(() -> {
            if (this.state != null) {
                this.operations.add(new TouchOperation(this.getRawName(), this.getLockName(), currentThreadId));
                return CompletableFuture.completedFuture(this.state != NULL);
            }
            return this.isExistsAsync().thenApply(res -> {
                this.operations.add(new TouchOperation(this.getRawName(), this.getLockName(), currentThreadId));
                return res;
            });
        });
    }

    @Override
    public RFuture<Boolean> unlinkAsync() {
        this.checkState();
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(() -> {
            if (this.state != null) {
                this.operations.add(new UnlinkOperation(this.getRawName(), this.getLockName(), currentThreadId));
                if (this.state == NULL) {
                    return CompletableFuture.completedFuture(false);
                }
                this.state = NULL;
                return CompletableFuture.completedFuture(true);
            }
            return this.isExistsAsync().thenApply(res -> {
                this.operations.add(new UnlinkOperation(this.getRawName(), this.getLockName(), currentThreadId));
                this.state = NULL;
                return res;
            });
        });
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        this.checkState();
        long threadId = Thread.currentThread().getId();
        return this.executeLocked(() -> {
            if (this.state != null) {
                this.operations.add(new DeleteOperation(this.getRawName(), this.getLockName(), this.transactionId, threadId));
                if (this.state == NULL) {
                    return CompletableFuture.completedFuture(false);
                }
                this.state = NULL;
                return CompletableFuture.completedFuture(true);
            }
            return this.isExistsAsync().thenApply(res -> {
                this.operations.add(new DeleteOperation(this.getRawName(), this.getLockName(), this.transactionId, threadId));
                this.state = NULL;
                return res;
            });
        });
    }

    @Override
    public RFuture<V> getAsync() {
        this.checkState();
        if (this.state != null) {
            if (this.state == NULL) {
                return new CompletableFutureWrapper<Object>(null);
            }
            return new CompletableFutureWrapper<Object>(this.state);
        }
        return super.getAsync();
    }

    @Override
    public RFuture<Boolean> compareAndSetAsync(V expect, V update) {
        this.checkState();
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(() -> {
            if (this.state != null) {
                this.operations.add(new BucketCompareAndSetOperation<Object>(this.getRawName(), this.getLockName(), this.getCodec(), expect, update, this.transactionId, currentThreadId));
                if (this.state == NULL && expect == null || this.isEquals(this.state, expect)) {
                    this.state = update == null ? NULL : update;
                    return CompletableFuture.completedFuture(true);
                }
                return CompletableFuture.completedFuture(false);
            }
            return this.getAsync().thenApply(res -> {
                this.operations.add(new BucketCompareAndSetOperation<Object>(this.getRawName(), this.getLockName(), this.getCodec(), expect, update, this.transactionId, currentThreadId));
                if (res == null && expect == null || this.isEquals(res, expect)) {
                    this.state = update == null ? NULL : update;
                    return true;
                }
                return false;
            });
        });
    }

    @Override
    public RFuture<V> getAndSetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        return this.getAndSet(value, new BucketGetAndSetOperation(this.getRawName(), this.getLockName(), this.getCodec(), value, timeToLive, timeUnit, this.transactionId));
    }

    @Override
    public RFuture<V> getAndSetAsync(V value) {
        return this.getAndSet(value, new BucketGetAndSetOperation(this.getRawName(), this.getLockName(), this.getCodec(), value, this.transactionId));
    }

    private RFuture<V> getAndSet(V newValue, TransactionalOperation operation) {
        this.checkState();
        return this.executeLocked(() -> {
            if (this.state != null) {
                Object prevValue = this.state == NULL ? null : this.state;
                this.operations.add(operation);
                this.state = newValue == null ? NULL : newValue;
                return CompletableFuture.completedFuture(prevValue);
            }
            return this.getAsync().thenApply(res -> {
                this.state = newValue == null ? NULL : newValue;
                this.operations.add(operation);
                return res;
            });
        });
    }

    @Override
    public RFuture<V> getAndDeleteAsync() {
        this.checkState();
        long currentThreadId = Thread.currentThread().getId();
        return this.executeLocked(() -> {
            if (this.state != null) {
                Object prevValue = this.state == NULL ? null : this.state;
                this.operations.add(new BucketGetAndDeleteOperation(this.getRawName(), this.getLockName(), this.getCodec(), this.transactionId, currentThreadId));
                this.state = NULL;
                return CompletableFuture.completedFuture(prevValue);
            }
            return this.getAsync().thenApply(res -> {
                this.state = NULL;
                this.operations.add(new BucketGetAndDeleteOperation(this.getRawName(), this.getLockName(), this.getCodec(), this.transactionId, currentThreadId));
                return res;
            });
        });
    }

    @Override
    public RFuture<Void> setAsync(V newValue) {
        long currentThreadId = Thread.currentThread().getId();
        return this.setAsync(newValue, new BucketSetOperation(this.getRawName(), this.getLockName(), this.getCodec(), newValue, this.transactionId, currentThreadId));
    }

    private RFuture<Void> setAsync(V newValue, TransactionalOperation operation) {
        this.checkState();
        return this.executeLocked(() -> {
            this.operations.add(operation);
            this.state = newValue == null ? NULL : newValue;
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public RFuture<Void> setAsync(V value, long timeToLive, TimeUnit timeUnit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.setAsync(value, new BucketSetOperation(this.getRawName(), this.getLockName(), this.getCodec(), value, timeToLive, timeUnit, this.transactionId, currentThreadId));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V newValue) {
        long currentThreadId = Thread.currentThread().getId();
        return this.trySet(newValue, new BucketTrySetOperation(this.getRawName(), this.getLockName(), this.getCodec(), newValue, this.transactionId, currentThreadId));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        long currentThreadId = Thread.currentThread().getId();
        return this.trySet(value, new BucketTrySetOperation(this.getRawName(), this.getLockName(), this.getCodec(), value, timeToLive, timeUnit, this.transactionId, currentThreadId));
    }

    private RFuture<Boolean> trySet(V newValue, TransactionalOperation operation) {
        this.checkState();
        return this.executeLocked(() -> {
            if (this.state != null) {
                this.operations.add(operation);
                if (this.state == NULL) {
                    this.state = newValue == null ? NULL : newValue;
                    return CompletableFuture.completedFuture(true);
                }
                return CompletableFuture.completedFuture(false);
            }
            return this.getAsync().thenApply(res -> {
                this.operations.add(operation);
                if (res == null) {
                    this.state = newValue == null ? NULL : newValue;
                    return true;
                }
                return false;
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEquals(Object value, Object oldValue) {
        ByteBuf valueBuf = this.encode(value);
        ByteBuf oldValueBuf = this.encode(oldValue);
        try {
            boolean bl = valueBuf.equals((Object)oldValueBuf);
            return bl;
        }
        finally {
            valueBuf.readableBytes();
            oldValueBuf.readableBytes();
        }
    }

    protected <R> RFuture<R> executeLocked(Supplier<CompletionStage<R>> runnable) {
        RLock lock = this.getLock();
        CompletionStage f = lock.lockAsync(this.timeout, TimeUnit.MILLISECONDS).thenCompose(res -> (CompletionStage)runnable.get());
        return new CompletableFutureWrapper(f);
    }

    private RLock getLock() {
        return new RedissonTransactionalLock(this.commandExecutor, this.getLockName(), this.transactionId);
    }

    private String getLockName() {
        return this.getRawName() + ":transaction_lock";
    }

    protected void checkState() {
        if (this.executed.get()) {
            throw new IllegalStateException("Unable to execute operation. Transaction is in finished state!");
        }
    }
}

