/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.webhook.api.WebHookConfig;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/webhook/insertWebHookConfig")
public class InsertWebHookConfigHandler
extends AbstractHttpHandler {
    private static final Logger log = LoggerFactory.getLogger(InsertWebHookConfigHandler.class);
    private final WebHookConfigOperation operation;

    public InsertWebHookConfigHandler(WebHookConfigOperation operation, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.operation = operation;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
        String requestBody = NetUtils.parsePostBody((HttpExchange)httpExchange);
        WebHookConfig webHookConfig = (WebHookConfig)JsonUtils.parseObject((String)requestBody, WebHookConfig.class);
        try (OutputStream out = httpExchange.getResponseBody();){
            Integer code = this.operation.insertWebHookConfig(webHookConfig);
            String result = 1 == code ? "insertWebHookConfig Succeed!" : "insertWebHookConfig Failed!";
            out.write(result.getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            log.error("get WebHookConfigOperation implementation Failed.", (Throwable)e);
        }
    }
}

