/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.consumer;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.EventMeshAction;
import org.apache.eventmesh.api.EventMeshAsyncConsumeContext;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.utils.ThreadUtils;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;
import org.apache.eventmesh.runtime.core.plugin.MQConsumerWrapper;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupTopicConfig;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.EventMeshProducer;
import org.apache.eventmesh.runtime.core.protocol.grpc.producer.SendMessageContext;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.HandleMsgContext;
import org.apache.eventmesh.runtime.core.protocol.grpc.push.MessageHandler;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventMeshConsumer.class);
    private final transient String consumerGroup;
    private final transient EventMeshGrpcServer eventMeshGrpcServer;
    private final transient EventMeshGrpcConfiguration eventMeshGrpcConfiguration;
    private final transient MQConsumerWrapper persistentMqConsumer;
    private final transient MQConsumerWrapper broadcastMqConsumer;
    private final transient MessageHandler messageHandler;
    private transient ServiceState serviceState;
    private final transient Map<String, ConsumerGroupTopicConfig> consumerGroupTopicConfig = new ConcurrentHashMap<String, ConsumerGroupTopicConfig>();

    public EventMeshConsumer(EventMeshGrpcServer eventMeshGrpcServer, String consumerGroup) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
        this.eventMeshGrpcConfiguration = eventMeshGrpcServer.getEventMeshGrpcConfiguration();
        this.consumerGroup = consumerGroup;
        this.messageHandler = new MessageHandler(consumerGroup, eventMeshGrpcServer.getPushMsgExecutor());
        this.persistentMqConsumer = new MQConsumerWrapper(this.eventMeshGrpcConfiguration.getEventMeshStoragePluginType());
        this.broadcastMqConsumer = new MQConsumerWrapper(this.eventMeshGrpcConfiguration.getEventMeshStoragePluginType());
    }

    public synchronized boolean registerClient(ConsumerGroupClient client) {
        boolean requireRestart = false;
        ConsumerGroupTopicConfig topicConfig = this.consumerGroupTopicConfig.get(client.getTopic());
        if (topicConfig == null) {
            topicConfig = ConsumerGroupTopicConfig.buildTopicConfig(this.consumerGroup, client.getTopic(), client.getSubscriptionMode(), client.getGrpcType());
            this.consumerGroupTopicConfig.put(client.getTopic(), topicConfig);
            requireRestart = true;
        }
        topicConfig.registerClient(client);
        return requireRestart;
    }

    public synchronized boolean deregisterClient(ConsumerGroupClient client) {
        boolean requireRestart = false;
        ConsumerGroupTopicConfig topicConfig = this.consumerGroupTopicConfig.get(client.getTopic());
        if (topicConfig != null) {
            topicConfig.deregisterClient(client);
            if (topicConfig.getSize() == 0) {
                this.consumerGroupTopicConfig.remove(client.getTopic());
                requireRestart = true;
            }
        }
        return requireRestart;
    }

    public synchronized void init() throws Exception {
        if (MapUtils.isEmpty(this.consumerGroupTopicConfig)) {
            return;
        }
        Properties keyValue = new Properties();
        keyValue.put("isBroadcast", "false");
        keyValue.put("consumerGroup", this.consumerGroup);
        keyValue.put("eventMeshIDC", this.eventMeshGrpcConfiguration.getEventMeshIDC());
        keyValue.put("instanceName", EventMeshUtil.buildMeshClientID(this.consumerGroup, this.eventMeshGrpcConfiguration.getEventMeshCluster()));
        this.persistentMqConsumer.init(keyValue);
        this.persistentMqConsumer.registerEventListener(this.createEventListener(SubscriptionMode.CLUSTERING));
        Properties broadcastKeyValue = new Properties();
        broadcastKeyValue.put("isBroadcast", "true");
        broadcastKeyValue.put("consumerGroup", this.consumerGroup);
        broadcastKeyValue.put("eventMeshIDC", this.eventMeshGrpcConfiguration.getEventMeshIDC());
        broadcastKeyValue.put("instanceName", EventMeshUtil.buildMeshClientID(this.consumerGroup, this.eventMeshGrpcConfiguration.getEventMeshCluster()));
        this.broadcastMqConsumer.init(broadcastKeyValue);
        this.broadcastMqConsumer.registerEventListener(this.createEventListener(SubscriptionMode.BROADCASTING));
        this.serviceState = ServiceState.INITED;
        if (log.isInfoEnabled()) {
            log.info("EventMeshConsumer [{}] initialized.............", (Object)this.consumerGroup);
        }
    }

    public synchronized void start() throws Exception {
        if (MapUtils.isEmpty(this.consumerGroupTopicConfig)) {
            return;
        }
        this.consumerGroupTopicConfig.forEach((k, v) -> {
            try {
                this.subscribe((String)k, v.getSubscriptionMode());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        this.persistentMqConsumer.start();
        this.broadcastMqConsumer.start();
        this.serviceState = ServiceState.RUNNING;
        if (log.isInfoEnabled()) {
            log.info("EventMeshConsumer [{}] started..........", (Object)this.consumerGroup);
        }
    }

    public synchronized void shutdown() throws Exception {
        this.persistentMqConsumer.shutdown();
        this.broadcastMqConsumer.shutdown();
        this.serviceState = ServiceState.STOPPED;
        if (log.isInfoEnabled()) {
            log.info("EventMeshConsumer [{}] shutdown.........", (Object)this.consumerGroup);
        }
    }

    public ServiceState getStatus() {
        return this.serviceState;
    }

    public void subscribe(String topic, SubscriptionMode subscriptionMode) throws Exception {
        if (SubscriptionMode.CLUSTERING == subscriptionMode) {
            this.persistentMqConsumer.subscribe(topic);
        } else if (SubscriptionMode.BROADCASTING == subscriptionMode) {
            this.broadcastMqConsumer.subscribe(topic);
        } else {
            throw new Exception("Subscribe Failed. Incorrect Subscription Mode");
        }
    }

    public void unsubscribe(SubscriptionItem subscriptionItem) throws Exception {
        SubscriptionMode mode = subscriptionItem.getMode();
        String topic = subscriptionItem.getTopic();
        if (SubscriptionMode.CLUSTERING == mode) {
            this.persistentMqConsumer.unsubscribe(topic);
        } else if (SubscriptionMode.BROADCASTING == mode) {
            this.broadcastMqConsumer.unsubscribe(topic);
        } else {
            throw new Exception("Unsubscribe Failed. Incorrect Subscription Mode");
        }
    }

    public void updateOffset(SubscriptionMode subscriptionMode, List<CloudEvent> events, AbstractContext context) throws Exception {
        if (SubscriptionMode.CLUSTERING == subscriptionMode) {
            this.persistentMqConsumer.updateOffset(events, context);
        } else if (SubscriptionMode.BROADCASTING == subscriptionMode) {
            this.broadcastMqConsumer.updateOffset(events, context);
        } else {
            throw new Exception("Subscribe Failed. Incorrect Subscription Mode");
        }
    }

    private EventListener createEventListener(SubscriptionMode subscriptionMode) {
        return (event, context) -> {
            event = CloudEventBuilder.from((CloudEvent)event).withExtension("reqmq2eventmeshtimestamp", String.valueOf(System.currentTimeMillis())).build();
            String topic = event.getSubject();
            String bizSeqNo = Optional.ofNullable((String)event.getExtension("searchkeys")).orElseGet(() -> "");
            String uniqueId = Optional.ofNullable((String)event.getExtension("rmbuniqid")).orElseGet(() -> "");
            if (log.isDebugEnabled()) {
                log.debug("message|mq2eventMesh|topic={}|msg={}", (Object)topic, (Object)event);
            } else {
                if (log.isInfoEnabled()) {
                    log.info("message|mq2eventMesh|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{topic, bizSeqNo, uniqueId});
                }
                this.eventMeshGrpcServer.getMetricsMonitor().recordReceiveMsgFromQueue();
            }
            EventMeshAsyncConsumeContext eventMeshAsyncConsumeContext = (EventMeshAsyncConsumeContext)context;
            ConsumerGroupTopicConfig topicConfig = this.consumerGroupTopicConfig.get(topic);
            if (topicConfig != null) {
                HandleMsgContext handleMsgContext = new HandleMsgContext(this.consumerGroup, event, subscriptionMode, topicConfig.getGrpcType(), eventMeshAsyncConsumeContext.getAbstractContext(), this.eventMeshGrpcServer, this, topicConfig);
                if (this.messageHandler.handle(handleMsgContext)) {
                    eventMeshAsyncConsumeContext.commit(EventMeshAction.ManualAck);
                    return;
                }
                try {
                    ThreadUtils.sleep((long)5L, (TimeUnit)TimeUnit.SECONDS);
                    this.sendMessageBack(this.consumerGroup, event, uniqueId, bizSeqNo);
                }
                catch (Exception exception) {}
            } else if (log.isDebugEnabled()) {
                log.debug("no active consumer for topic={}|msg={}", (Object)topic, (Object)event);
            }
            eventMeshAsyncConsumeContext.commit(EventMeshAction.CommitMessage);
        };
    }

    public void sendMessageBack(final String consumerGroup, CloudEvent event, final String uniqueId, final String bizSeqNo) throws Exception {
        EventMeshProducer producer = this.eventMeshGrpcServer.getProducerManager().getEventMeshProducer(consumerGroup);
        if (producer == null) {
            if (log.isWarnEnabled()) {
                log.warn("consumer:{} consume fail, sendMessageBack, bizSeqNo:{}, uniqueId:{}", new Object[]{consumerGroup, bizSeqNo, uniqueId});
            }
            return;
        }
        SendMessageContext sendMessageBackContext = new SendMessageContext(bizSeqNo, event, producer, this.eventMeshGrpcServer);
        producer.send(sendMessageBackContext, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
            }

            public void onException(OnExceptionContext context) {
                if (log.isWarnEnabled()) {
                    log.warn("consumer:{} consume fail, sendMessageBack, bizSeqNo:{}, uniqueId:{}", new Object[]{consumerGroup, bizSeqNo, uniqueId});
                }
            }
        });
    }
}

