/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.trace;

import com.navercorp.pinpoint.common.trace.DefaultServiceType;
import com.navercorp.pinpoint.common.trace.ServiceType;

public class ServiceTypeBuilder {
    private final short code;
    private final String name;
    private final String desc;
    private boolean terminal;
    private boolean queue;
    private boolean recordStatistics;
    private boolean includeDestinationId;
    private boolean alias;

    public ServiceTypeBuilder(short code, String name) {
        this(code, name, name);
    }

    public ServiceTypeBuilder(short code, String name, String desc) {
        this.code = code;
        this.name = name;
        this.desc = desc;
    }

    public ServiceTypeBuilder terminal(boolean terminal) {
        this.terminal = terminal;
        return this;
    }

    public ServiceTypeBuilder queue(boolean queue) {
        this.queue = queue;
        return this;
    }

    public ServiceTypeBuilder recordStatistics(boolean recordStatistics) {
        this.recordStatistics = recordStatistics;
        return this;
    }

    public ServiceTypeBuilder includeDestinationId(boolean includeDestinationId) {
        this.includeDestinationId = includeDestinationId;
        return this;
    }

    public ServiceTypeBuilder alias(boolean alias) {
        this.alias = alias;
        return this;
    }

    short code() {
        return this.code;
    }

    String name() {
        return this.name;
    }

    String desc() {
        return this.desc;
    }

    boolean terminal() {
        return this.terminal;
    }

    boolean queue() {
        return this.queue;
    }

    boolean recordStatistics() {
        return this.recordStatistics;
    }

    boolean includeDestinationId() {
        return this.includeDestinationId;
    }

    boolean alias() {
        return this.alias;
    }

    public ServiceType build() {
        return new DefaultServiceType(this);
    }
}

