/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class StringJoiner {
    private final String delimiter;
    private final List<String> list = new ArrayList<String>();

    public StringJoiner(String delimiter) {
        this.delimiter = Objects.requireNonNull(delimiter, "delimiter");
    }

    public void add(String str) {
        this.list.add(str);
    }

    public String toString() {
        int bufferSize = StringJoiner.getBufferSize(this.list, this.delimiter);
        StringBuilder buffer = new StringBuilder(bufferSize);
        StringJoiner.build(buffer, this.list, this.delimiter);
        return buffer.toString();
    }

    static void build(StringBuilder buffer, Collection<String> list, String separator) {
        boolean first = true;
        for (String str : list) {
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(str);
        }
    }

    static int getBufferSize(Collection<String> list, String separator) {
        int length = separator.length();
        int bufferSize = 0;
        boolean first = true;
        for (String str : list) {
            if (first) {
                first = false;
            } else {
                bufferSize += length;
            }
            bufferSize += StringUtils.getLength(str, 4);
        }
        return bufferSize;
    }
}

