/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util.apache;

import com.navercorp.pinpoint.common.util.apache.IntHashMap;
import java.util.Map;
import java.util.Objects;

public final class IntHashMapUtils {
    private IntHashMapUtils() {
    }

    public static <V> IntHashMap<V> copy(Map<Integer, V> target) {
        Objects.requireNonNull(target, "target");
        IntHashMap<V> copyMap = new IntHashMap<V>();
        for (Map.Entry<Integer, V> entry : target.entrySet()) {
            copyMap.put(entry.getKey(), entry.getValue());
        }
        return copyMap;
    }

    public static <V> IntHashMap<V> copyShortMap(Map<Short, V> target) {
        Objects.requireNonNull(target, "target");
        IntHashMap<V> copyMap = new IntHashMap<V>();
        for (Map.Entry<Short, V> entry : target.entrySet()) {
            copyMap.put(entry.getKey().shortValue(), entry.getValue());
        }
        return copyMap;
    }
}

