/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.rpc.MessageListener;
import com.navercorp.pinpoint.rpc.StateChangeEventListener;
import com.navercorp.pinpoint.rpc.client.ClientHandlerFactory;
import com.navercorp.pinpoint.rpc.client.ClientOption;
import com.navercorp.pinpoint.rpc.client.ConnectionFactory;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClientHandler;
import com.navercorp.pinpoint.rpc.client.HandshakerFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClientHandler;
import com.navercorp.pinpoint.rpc.client.PinpointClientHandshaker;
import com.navercorp.pinpoint.rpc.client.SocketAddressProvider;
import com.navercorp.pinpoint.rpc.cluster.ClusterOption;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelMessageHandler;
import java.util.List;
import java.util.Objects;
import org.jboss.netty.util.Timer;

public class DefaultPinpointClientHandlerFactory
implements ClientHandlerFactory {
    private final ClientOption clientOption;
    private final ClusterOption clusterOption;
    private final HandshakerFactory handshakerFactory;
    private final MessageListener messageListener;
    private final ServerStreamChannelMessageHandler serverStreamChannelMessageHandler;
    private final List<StateChangeEventListener> stateChangeEventListeners;

    public DefaultPinpointClientHandlerFactory(ClientOption clientOption, ClusterOption clusterOption, HandshakerFactory handshakerFactory, MessageListener messageListener, ServerStreamChannelMessageHandler serverStreamChannelMessageHandler, List<StateChangeEventListener> stateChangeEventListeners) {
        this.clientOption = Objects.requireNonNull(clientOption, "clientOption");
        this.clusterOption = Objects.requireNonNull(clusterOption, "clusterOption");
        this.handshakerFactory = Objects.requireNonNull(handshakerFactory, "handshakerFactory");
        this.messageListener = Objects.requireNonNull(messageListener, "messageListener");
        this.serverStreamChannelMessageHandler = Objects.requireNonNull(serverStreamChannelMessageHandler, "serverStreamChannelMessageHandler");
        this.stateChangeEventListeners = Objects.requireNonNull(stateChangeEventListeners, "stateChangeEventListeners");
    }

    @Override
    public PinpointClientHandler newClientHandler(ConnectionFactory connectionFactory, SocketAddressProvider remoteAddressProvider, Timer channelTimer, boolean reconnect) {
        PinpointClientHandshaker handshaker = this.handshakerFactory.newHandShaker(channelTimer);
        DefaultPinpointClientHandler clientHandler = new DefaultPinpointClientHandler(connectionFactory, remoteAddressProvider, handshaker, this.clusterOption, this.clientOption, channelTimer, this.messageListener, this.serverStreamChannelMessageHandler, this.stateChangeEventListeners);
        if (reconnect) {
            clientHandler.initReconnect();
        }
        return clientHandler;
    }
}

