/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.server;

import com.navercorp.pinpoint.rpc.common.SocketState;
import com.navercorp.pinpoint.rpc.common.SocketStateChangeResult;
import com.navercorp.pinpoint.rpc.common.SocketStateCode;
import com.navercorp.pinpoint.rpc.server.DefaultPinpointServer;
import com.navercorp.pinpoint.rpc.server.handler.ServerStateChangeEventHandler;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultPinpointServerState {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final DefaultPinpointServer pinpointServer;
    private final List<ServerStateChangeEventHandler> stateChangeEventListeners;
    private final SocketState state;

    public DefaultPinpointServerState(DefaultPinpointServer pinpointServer, List<ServerStateChangeEventHandler> stateChangeEventListeners) {
        this.pinpointServer = pinpointServer;
        this.stateChangeEventListeners = stateChangeEventListeners;
        this.state = new SocketState();
    }

    SocketStateChangeResult toConnected() {
        SocketStateCode nextState = SocketStateCode.CONNECTED;
        return this.to(nextState);
    }

    SocketStateChangeResult toRunWithoutHandshake() {
        SocketStateCode nextState = SocketStateCode.RUN_WITHOUT_HANDSHAKE;
        return this.to(nextState);
    }

    SocketStateChangeResult toRunSimplex() {
        SocketStateCode nextState = SocketStateCode.RUN_SIMPLEX;
        return this.to(nextState);
    }

    SocketStateChangeResult toRunDuplex() {
        SocketStateCode nextState = SocketStateCode.RUN_DUPLEX;
        return this.to(nextState);
    }

    SocketStateChangeResult toBeingClose() {
        SocketStateCode nextState = SocketStateCode.BEING_CLOSE_BY_SERVER;
        return this.to(nextState);
    }

    SocketStateChangeResult toBeingCloseByPeer() {
        SocketStateCode nextState = SocketStateCode.BEING_CLOSE_BY_CLIENT;
        return this.to(nextState);
    }

    SocketStateChangeResult toClosed() {
        SocketStateCode nextState = SocketStateCode.CLOSED_BY_SERVER;
        return this.to(nextState);
    }

    SocketStateChangeResult toClosedByPeer() {
        SocketStateCode nextState = SocketStateCode.CLOSED_BY_CLIENT;
        return this.to(nextState);
    }

    SocketStateChangeResult toUnexpectedClosed() {
        SocketStateCode nextState = SocketStateCode.UNEXPECTED_CLOSE_BY_SERVER;
        return this.to(nextState);
    }

    SocketStateChangeResult toUnexpectedClosedByPeer() {
        SocketStateCode nextState = SocketStateCode.UNEXPECTED_CLOSE_BY_CLIENT;
        return this.to(nextState);
    }

    SocketStateChangeResult toErrorUnknown() {
        SocketStateCode nextState = SocketStateCode.ERROR_UNKNOWN;
        return this.to(nextState);
    }

    SocketStateChangeResult toErrorSyncStateSession() {
        SocketStateCode nextState = SocketStateCode.ERROR_SYNC_STATE_SESSION;
        return this.to(nextState);
    }

    private SocketStateChangeResult to(SocketStateCode nextState) {
        String objectUniqName = this.pinpointServer.getObjectUniqName();
        this.logger.debug("{} stateTo() started. to:{}", (Object)objectUniqName, (Object)nextState);
        SocketStateChangeResult stateChangeResult = this.state.to(nextState);
        if (stateChangeResult.isChange()) {
            this.executeChangeEventHandler(this.pinpointServer, nextState);
        }
        this.logger.info("{} stateTo() completed. {}", (Object)objectUniqName, (Object)stateChangeResult);
        return stateChangeResult;
    }

    private void executeChangeEventHandler(DefaultPinpointServer pinpointServer, SocketStateCode nextState) {
        for (ServerStateChangeEventHandler eachListener : this.stateChangeEventListeners) {
            try {
                eachListener.stateUpdated(pinpointServer, nextState);
            }
            catch (Exception e) {
                this.logger.warn("Please handling exception in stateUpdated method. message:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    boolean isEnableCommunication() {
        return SocketStateCode.isRun(this.getCurrentStateCode());
    }

    boolean isEnableDuplexCommunication() {
        return SocketStateCode.isRunDuplex(this.getCurrentStateCode());
    }

    SocketStateCode getCurrentStateCode() {
        return this.state.getCurrentState();
    }
}

