/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.server;

import com.navercorp.pinpoint.common.annotations.VisibleForTesting;
import com.navercorp.pinpoint.common.profiler.concurrent.PinpointThreadFactory;
import com.navercorp.pinpoint.common.util.CpuUtils;
import com.navercorp.pinpoint.rpc.PinpointSocket;
import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.PipelineFactory;
import com.navercorp.pinpoint.rpc.cluster.ClusterOption;
import com.navercorp.pinpoint.rpc.packet.ServerClosePacket;
import com.navercorp.pinpoint.rpc.server.ChannelFilter;
import com.navercorp.pinpoint.rpc.server.DefaultPinpointServer;
import com.navercorp.pinpoint.rpc.server.HealthCheckManager;
import com.navercorp.pinpoint.rpc.server.LoggingServerMessageListenerFactory;
import com.navercorp.pinpoint.rpc.server.PinpointServerConfig;
import com.navercorp.pinpoint.rpc.server.ServerCodecPipelineFactory;
import com.navercorp.pinpoint.rpc.server.ServerMessageListener;
import com.navercorp.pinpoint.rpc.server.ServerMessageListenerFactory;
import com.navercorp.pinpoint.rpc.server.ServerOption;
import com.navercorp.pinpoint.rpc.server.handler.ServerStateChangeEventHandler;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelMessageHandler;
import com.navercorp.pinpoint.rpc.util.LoggerFactorySetup;
import com.navercorp.pinpoint.rpc.util.TimerFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.BossPool;
import org.jboss.netty.channel.socket.nio.NioServerBossPool;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioWorkerPool;
import org.jboss.netty.channel.socket.nio.WorkerPool;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.Timer;

public class PinpointServerAcceptor
implements PinpointServerConfig {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private static final int WORKER_COUNT = CpuUtils.cpuCount();
    private volatile boolean released;
    private ServerBootstrap bootstrap;
    private final ChannelFilter channelConnectedFilter;
    private Channel serverChannel;
    private final ChannelGroup channelGroup = new DefaultChannelGroup("PinpointServerFactory");
    private final PinpointServerChannelHandler nettyChannelHandler = new PinpointServerChannelHandler();
    private ServerMessageListenerFactory messageListenerFactory = new LoggingServerMessageListenerFactory();
    private ServerStreamChannelMessageHandler serverStreamChannelMessageHandler = ServerStreamChannelMessageHandler.DISABLED_INSTANCE;
    private final List<ServerStateChangeEventHandler> stateChangeEventHandler = new ArrayList<ServerStateChangeEventHandler>();
    private final Timer healthCheckTimer;
    private final HealthCheckManager healthCheckManager;
    private final Timer requestManagerTimer;
    private final ServerOption serverOption;
    private final PipelineFactory pipelineFactory;

    public PinpointServerAcceptor() {
        this(ServerOption.getDefaultServerOption(), ChannelFilter.BYPASS);
    }

    public PinpointServerAcceptor(ChannelFilter channelConnectedFilter) {
        this(ServerOption.getDefaultServerOption(), channelConnectedFilter);
    }

    public PinpointServerAcceptor(ChannelFilter channelConnectedFilter, PipelineFactory pipelineFactory) {
        this(ServerOption.getDefaultServerOption(), channelConnectedFilter, pipelineFactory);
    }

    public PinpointServerAcceptor(ServerOption serverOption, ChannelFilter channelConnectedFilter) {
        this(serverOption, channelConnectedFilter, new ServerCodecPipelineFactory());
    }

    public PinpointServerAcceptor(ServerOption serverOption, ChannelFilter channelConnectedFilter, PipelineFactory pipelineFactory) {
        ServerBootstrap bootstrap = this.createBootStrap(1, WORKER_COUNT);
        this.setOptions(bootstrap);
        this.bootstrap = bootstrap;
        this.serverOption = Objects.requireNonNull(serverOption, "serverOption");
        this.logger.info("serverOption : {}", (Object)serverOption);
        this.healthCheckTimer = TimerFactory.createHashedWheelTimer("PinpointServerSocket-HealthCheckTimer", 50L, TimeUnit.MILLISECONDS, 512);
        this.healthCheckManager = new HealthCheckManager(this.healthCheckTimer, serverOption.getHealthCheckPacketWaitTimeMillis(), this.channelGroup);
        this.requestManagerTimer = TimerFactory.createHashedWheelTimer("PinpointServerSocket-RequestManager", 50L, TimeUnit.MILLISECONDS, 512);
        this.channelConnectedFilter = Objects.requireNonNull(channelConnectedFilter, "channelConnectedFilter");
        this.pipelineFactory = Objects.requireNonNull(pipelineFactory, "pipelineFactory");
        this.addPipeline(bootstrap, pipelineFactory);
    }

    private ServerBootstrap createBootStrap(int bossCount, int workerCount) {
        ExecutorService boss = Executors.newCachedThreadPool((ThreadFactory)new PinpointThreadFactory("Pinpoint-Server-Boss", true));
        NioServerBossPool nioServerBossPool = new NioServerBossPool((Executor)boss, bossCount, ThreadNameDeterminer.CURRENT);
        ExecutorService worker = Executors.newCachedThreadPool((ThreadFactory)new PinpointThreadFactory("Pinpoint-Server-Worker", true));
        NioWorkerPool nioWorkerPool = new NioWorkerPool((Executor)worker, workerCount, ThreadNameDeterminer.CURRENT);
        NioServerSocketChannelFactory nioClientSocketChannelFactory = new NioServerSocketChannelFactory((BossPool)nioServerBossPool, (WorkerPool)nioWorkerPool);
        return new ServerBootstrap((ChannelFactory)nioClientSocketChannelFactory);
    }

    private void setOptions(ServerBootstrap bootstrap) {
        bootstrap.setOption("child.tcpNoDelay", (Object)true);
        bootstrap.setOption("child.keepAlive", (Object)true);
        bootstrap.setOption("child.sendBufferSize", (Object)65536);
        bootstrap.setOption("child.receiveBufferSize", (Object)65536);
    }

    private void addPipeline(ServerBootstrap bootstrap, final PipelineFactory pipelineFactory) {
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = pipelineFactory.newPipeline();
                pipeline.addLast("handler", (ChannelHandler)PinpointServerAcceptor.this.nettyChannelHandler);
                return pipeline;
            }
        });
    }

    @VisibleForTesting
    void setPipelineFactory(ChannelPipelineFactory channelPipelineFactory) {
        Objects.requireNonNull(channelPipelineFactory, "channelPipelineFactory");
        this.bootstrap.setPipelineFactory(channelPipelineFactory);
    }

    @VisibleForTesting
    public void setMessageHandler(final ChannelHandler messageHandler) {
        Objects.requireNonNull(messageHandler, "messageHandler");
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = PinpointServerAcceptor.this.pipelineFactory.newPipeline();
                pipeline.addLast("handler", messageHandler);
                return pipeline;
            }
        });
    }

    public void bind(String host, int port) throws PinpointSocketException {
        InetSocketAddress bindAddress = new InetSocketAddress(host, port);
        this.bind(bindAddress);
    }

    public void bind(InetSocketAddress bindAddress) throws PinpointSocketException {
        if (this.released) {
            return;
        }
        this.logger.info("bind() {}", (Object)bindAddress);
        this.serverChannel = this.bootstrap.bind((SocketAddress)bindAddress);
        this.healthCheckManager.start(this.serverOption.getHealthCheckIntervalTimeMillis());
    }

    private DefaultPinpointServer createPinpointServer(Channel channel) {
        DefaultPinpointServer pinpointServer = new DefaultPinpointServer(channel, this);
        return pinpointServer;
    }

    @Override
    public long getDefaultRequestTimeout() {
        return this.serverOption.getRequestTimeoutMillis();
    }

    @Override
    public ServerMessageListener getMessageListener() {
        return this.messageListenerFactory.create();
    }

    public void setMessageListenerFactory(ServerMessageListenerFactory messageListenerFactory) {
        this.messageListenerFactory = Objects.requireNonNull(messageListenerFactory, "messageListenerFactory");
    }

    @Override
    public List<ServerStateChangeEventHandler> getStateChangeEventHandlers() {
        return this.stateChangeEventHandler;
    }

    public void addStateChangeEventHandler(ServerStateChangeEventHandler stateChangeEventHandler) {
        Objects.requireNonNull(stateChangeEventHandler, "stateChangeEventHandler");
        this.stateChangeEventHandler.add(stateChangeEventHandler);
    }

    @Override
    public ServerStreamChannelMessageHandler getServerStreamMessageHandler() {
        return this.serverStreamChannelMessageHandler;
    }

    public void setServerStreamChannelMessageHandler(ServerStreamChannelMessageHandler serverStreamChannelMessageHandler) {
        this.serverStreamChannelMessageHandler = Objects.requireNonNull(serverStreamChannelMessageHandler, "serverStreamChannelMessageHandler");
    }

    @Override
    public Timer getRequestManagerTimer() {
        return this.requestManagerTimer;
    }

    @Override
    public ClusterOption getClusterOption() {
        return this.serverOption.getClusterOption();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        PinpointServerAcceptor pinpointServerAcceptor = this;
        synchronized (pinpointServerAcceptor) {
            if (this.released) {
                return;
            }
            this.released = true;
        }
        this.healthCheckManager.stop();
        this.healthCheckTimer.stop();
        this.closePinpointServer();
        if (this.serverChannel != null) {
            ChannelFuture close = this.serverChannel.close();
            close.awaitUninterruptibly(this.serverOption.getServerCloseWaitTimeoutMillis(), TimeUnit.MILLISECONDS);
            this.serverChannel = null;
        }
        if (this.bootstrap != null) {
            this.bootstrap.releaseExternalResources();
            this.bootstrap = null;
        }
        this.requestManagerTimer.stop();
    }

    private void closePinpointServer() {
        for (Channel channel : this.channelGroup) {
            DefaultPinpointServer pinpointServer = (DefaultPinpointServer)channel.getAttachment();
            if (pinpointServer == null) continue;
            pinpointServer.sendClosePacket();
        }
    }

    public List<PinpointSocket> getWritableSocketList() {
        ArrayList<PinpointSocket> pinpointServerList = new ArrayList<PinpointSocket>();
        for (Channel channel : this.channelGroup) {
            DefaultPinpointServer pinpointServer = (DefaultPinpointServer)channel.getAttachment();
            if (pinpointServer == null || !pinpointServer.isEnableDuplexCommunication()) continue;
            pinpointServerList.add(pinpointServer);
        }
        return pinpointServerList;
    }

    static {
        LoggerFactorySetup.setupSlf4jLoggerFactory();
    }

    class PinpointServerChannelHandler
    extends SimpleChannelHandler {
        PinpointServerChannelHandler() {
        }

        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            Channel channel = e.getChannel();
            if (PinpointServerAcceptor.this.released) {
                PinpointServerAcceptor.this.logger.warn("already released. channel:{}", (Object)channel);
                channel.write((Object)new ServerClosePacket()).addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        future.getChannel().close();
                    }
                });
                return;
            }
            boolean accept = PinpointServerAcceptor.this.channelConnectedFilter.accept(channel);
            if (!accept) {
                PinpointServerAcceptor.this.logger.debug("channelConnected() channel discard. {}", (Object)channel);
                return;
            }
            PinpointServerAcceptor.this.logger.info("channelConnected started. channel:{}", (Object)channel);
            DefaultPinpointServer pinpointServer = PinpointServerAcceptor.this.createPinpointServer(channel);
            channel.setAttachment((Object)pinpointServer);
            PinpointServerAcceptor.this.channelGroup.add((Object)channel);
            pinpointServer.start();
            super.channelConnected(ctx, e);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            Channel channel = e.getChannel();
            boolean accept = PinpointServerAcceptor.this.channelConnectedFilter.accept(channel);
            if (!accept) {
                return;
            }
            super.exceptionCaught(ctx, e);
        }

        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            Channel channel = e.getChannel();
            DefaultPinpointServer pinpointServer = (DefaultPinpointServer)channel.getAttachment();
            if (pinpointServer != null) {
                pinpointServer.stop(PinpointServerAcceptor.this.released);
            }
            super.channelDisconnected(ctx, e);
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            Channel channel = e.getChannel();
            PinpointServerAcceptor.this.channelGroup.remove((Object)channel);
            super.channelClosed(ctx, e);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            Channel channel = e.getChannel();
            DefaultPinpointServer pinpointServer = (DefaultPinpointServer)channel.getAttachment();
            if (pinpointServer != null) {
                Object message = e.getMessage();
                pinpointServer.messageReceived(message);
            }
            super.messageReceived(ctx, e);
        }
    }
}

