/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.stream;

import com.navercorp.pinpoint.rpc.packet.stream.StreamClosePacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCode;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCreatePacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamPingPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamPongPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamResponsePacket;
import com.navercorp.pinpoint.rpc.stream.AbstractStreamChannel;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannel;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannelEventHandler;
import com.navercorp.pinpoint.rpc.stream.StreamChannelRepository;
import com.navercorp.pinpoint.rpc.stream.StreamChannelStateChangeEventHandler;
import com.navercorp.pinpoint.rpc.stream.StreamChannelStateCode;
import com.navercorp.pinpoint.rpc.stream.StreamException;
import java.net.SocketAddress;
import java.util.Objects;
import org.jboss.netty.channel.Channel;

public class NettyClientStreamChannel
extends AbstractStreamChannel
implements ClientStreamChannel {
    private final Channel channel;
    private final ClientStreamChannelEventHandler streamChannelEventHandler;

    public NettyClientStreamChannel(Channel channel, int streamId, StreamChannelRepository streamChannelRepository, ClientStreamChannelEventHandler streamChannelEventHandler) {
        super(streamId, streamChannelRepository);
        this.channel = Objects.requireNonNull(channel, "channel");
        this.streamChannelEventHandler = Objects.requireNonNull(streamChannelEventHandler, "streamChannelEventHandler");
    }

    public void connect(byte[] payload) throws StreamException {
        this.changeStateTo(StreamChannelStateCode.CONNECT_AWAIT, true);
        this.sendCreate(payload);
    }

    public void connectAndAwait(byte[] payload, long timeout) throws StreamException {
        this.connect(payload);
        boolean connected = this.awaitOpen(timeout);
        if (!connected) {
            throw new StreamException(StreamCode.CONNECTION_TIMEOUT);
        }
        this.logger.info("Open streamChannel initialization completed. streamChannel:{} ", (Object)this);
    }

    private void sendCreate(byte[] payload) {
        StreamCreatePacket packet = new StreamCreatePacket(this.getStreamId(), payload);
        this.write(StreamChannelStateCode.CONNECT_AWAIT, packet);
    }

    @Override
    public void sendPing(int requestId) {
        StreamPingPacket packet = new StreamPingPacket(this.getStreamId(), requestId);
        this.write(StreamChannelStateCode.CONNECTED, packet);
    }

    @Override
    public void sendPong(int requestId) {
        StreamPongPacket packet = new StreamPongPacket(this.getStreamId(), requestId);
        this.write(StreamChannelStateCode.CONNECTED, packet);
    }

    @Override
    public void close(StreamCode code) {
        this.clearStreamChannelResource();
        if (!StreamCode.isConnectionError(code)) {
            try {
                StreamClosePacket packet = new StreamClosePacket(this.getStreamId(), code);
                this.write(packet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void write(StreamPacket packet) {
        this.write(null, packet);
    }

    private void write(StreamChannelStateCode expectedCode, StreamPacket packet) {
        if (expectedCode != null) {
            this.state.assertState(expectedCode);
        }
        this.channel.write((Object)packet);
    }

    @Override
    public void handleStreamResponsePacket(StreamResponsePacket packet) throws StreamException {
        if (this.state.checkState(StreamChannelStateCode.CONNECTED)) {
            this.streamChannelEventHandler.handleStreamResponsePacket(this, packet);
        } else if (!this.state.checkState(StreamChannelStateCode.CONNECT_AWAIT)) {
            throw new StreamException(StreamCode.STATE_NOT_CONNECTED);
        }
    }

    @Override
    public void handleStreamClosePacket(StreamClosePacket packet) {
        this.streamChannelEventHandler.handleStreamClosePacket(this, packet);
        this.disconnect(packet.getCode());
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.getRemoteAddress();
    }

    @Override
    protected StreamChannelStateChangeEventHandler getStateChangeEventHandler() {
        return this.streamChannelEventHandler;
    }
}

