/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.grpc.consumer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.SubscriptionMode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.common.ServiceState;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.EventMeshConsumer;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.ConsumerGroupClient;
import org.apache.eventmesh.runtime.core.protocol.grpc.consumer.consumergroup.GrpcType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerManager {
    private static final Logger log = LoggerFactory.getLogger(ConsumerManager.class);
    private final transient EventMeshGrpcServer eventMeshGrpcServer;
    private final transient ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    private final transient Map<String, List<ConsumerGroupClient>> clientTable = new ConcurrentHashMap<String, List<ConsumerGroupClient>>();
    private final transient Map<String, EventMeshConsumer> consumerTable = new ConcurrentHashMap<String, EventMeshConsumer>();

    public ConsumerManager(EventMeshGrpcServer eventMeshGrpcServer) {
        this.eventMeshGrpcServer = eventMeshGrpcServer;
    }

    public Map<String, List<ConsumerGroupClient>> getClientTable() {
        return this.clientTable;
    }

    public void init() throws Exception {
        if (log.isInfoEnabled()) {
            log.info("Grpc ConsumerManager initialized.");
        }
    }

    public void start() throws Exception {
        this.startClientCheck();
        if (log.isInfoEnabled()) {
            log.info("Grpc ConsumerManager started.");
        }
    }

    public void shutdown() throws Exception {
        for (EventMeshConsumer consumer : this.consumerTable.values()) {
            consumer.shutdown();
        }
        this.scheduledExecutorService.shutdown();
        if (log.isInfoEnabled()) {
            log.info("Grpc ConsumerManager shutdown.");
        }
    }

    public EventMeshConsumer getEventMeshConsumer(String consumerGroup) {
        return this.consumerTable.computeIfAbsent(consumerGroup, key -> new EventMeshConsumer(this.eventMeshGrpcServer, consumerGroup));
    }

    public synchronized void registerClient(ConsumerGroupClient newClient) {
        String consumerGroup = newClient.getConsumerGroup();
        String topic = newClient.getTopic();
        GrpcType grpcType = newClient.getGrpcType();
        String url = newClient.getUrl();
        String ip = newClient.getIp();
        String pid = newClient.getPid();
        SubscriptionMode subscriptionMode = newClient.getSubscriptionMode();
        List<ConsumerGroupClient> localClients = this.clientTable.get(consumerGroup);
        if (localClients == null) {
            localClients = new ArrayList<ConsumerGroupClient>();
            localClients.add(newClient);
            this.clientTable.putIfAbsent(consumerGroup, localClients);
        } else {
            boolean isContains = false;
            for (ConsumerGroupClient localClient : localClients) {
                if (GrpcType.WEBHOOK == grpcType && StringUtils.equals((CharSequence)localClient.getTopic(), (CharSequence)topic) && StringUtils.equals((CharSequence)localClient.getUrl(), (CharSequence)url) && localClient.getSubscriptionMode() == subscriptionMode) {
                    isContains = true;
                    localClient.setUrl(newClient.getUrl());
                    localClient.setLastUpTime(newClient.getLastUpTime());
                    break;
                }
                if (GrpcType.STREAM != grpcType || !StringUtils.equals((CharSequence)localClient.getTopic(), (CharSequence)topic) || !StringUtils.equals((CharSequence)localClient.getIp(), (CharSequence)ip) || !StringUtils.equals((CharSequence)localClient.getPid(), (CharSequence)pid) || localClient.getSubscriptionMode() != subscriptionMode) continue;
                isContains = true;
                localClient.setEventEmitter(newClient.getEventEmitter());
                localClient.setLastUpTime(newClient.getLastUpTime());
                break;
            }
            if (!isContains) {
                localClients.add(newClient);
            }
        }
    }

    public boolean updateClientTime(ConsumerGroupClient client) {
        List<ConsumerGroupClient> localClients = this.clientTable.get(client.getConsumerGroup());
        if (CollectionUtils.isEmpty(localClients)) {
            return false;
        }
        for (ConsumerGroupClient localClient : localClients) {
            if (!StringUtils.equals((CharSequence)localClient.getIp(), (CharSequence)client.getIp()) || !StringUtils.equals((CharSequence)localClient.getPid(), (CharSequence)client.getPid()) || !StringUtils.equals((CharSequence)localClient.getSys(), (CharSequence)client.getSys()) || !StringUtils.equals((CharSequence)localClient.getTopic(), (CharSequence)client.getTopic())) continue;
            localClient.setLastUpTime(new Date());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deregisterClient(ConsumerGroupClient client) {
        String consumerGroup = client.getConsumerGroup();
        List<ConsumerGroupClient> localClients = this.clientTable.get(consumerGroup);
        if (CollectionUtils.isEmpty(localClients)) {
            return;
        }
        Iterator<ConsumerGroupClient> iterator = localClients.iterator();
        Map<String, List<ConsumerGroupClient>> map = this.clientTable;
        synchronized (map) {
            while (iterator.hasNext()) {
                ConsumerGroupClient localClient = iterator.next();
                if (!StringUtils.equals((CharSequence)localClient.getTopic(), (CharSequence)client.getTopic()) || localClient.getSubscriptionMode() != client.getSubscriptionMode()) continue;
                this.closeEventStream(localClient);
                iterator.remove();
            }
        }
        if (CollectionUtils.isEmpty(localClients)) {
            this.clientTable.remove(consumerGroup);
        }
    }

    private void closeEventStream(ConsumerGroupClient client) {
        if (client.getEventEmitter() != null) {
            client.getEventEmitter().onCompleted();
        }
    }

    public synchronized void restartEventMeshConsumer(String consumerGroup) throws Exception {
        EventMeshConsumer eventMeshConsumer = this.consumerTable.get(consumerGroup);
        if (eventMeshConsumer == null) {
            return;
        }
        if (ServiceState.RUNNING == eventMeshConsumer.getStatus()) {
            eventMeshConsumer.shutdown();
        }
        eventMeshConsumer.init();
        eventMeshConsumer.start();
        if (ServiceState.RUNNING != eventMeshConsumer.getStatus()) {
            this.consumerTable.remove(consumerGroup);
        }
    }

    private void startClientCheck() {
        int clientTimeout = this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().getEventMeshSessionExpiredInMills();
        if (clientTimeout > 0) {
            this.scheduledExecutorService.scheduleAtFixedRate(() -> {
                if (log.isDebugEnabled()) {
                    log.debug("grpc client info check");
                }
                LinkedList clientList = new LinkedList();
                this.clientTable.values().forEach(clients -> clientList.addAll(clients));
                if (log.isDebugEnabled()) {
                    log.debug("total number of ConsumerGroupClients: {}", (Object)clientList.size());
                }
                if (CollectionUtils.isEmpty(clientList)) {
                    return;
                }
                HashSet consumerGroupRestart = new HashSet();
                clientList.forEach(client -> {
                    if (System.currentTimeMillis() - client.getLastUpTime().getTime() > (long)clientTimeout) {
                        if (log.isWarnEnabled()) {
                            log.warn("client {} lastUpdate time {} over three heartbeat cycles. Removing it", (Object)JsonUtils.toJSONString((Object)client), (Object)client.getLastUpTime());
                        }
                        this.deregisterClient((ConsumerGroupClient)client);
                        if (this.getEventMeshConsumer(client.getConsumerGroup()).deregisterClient((ConsumerGroupClient)client)) {
                            consumerGroupRestart.add(client.getConsumerGroup());
                        }
                    }
                });
                consumerGroupRestart.forEach(consumerGroup -> {
                    block2: {
                        try {
                            this.restartEventMeshConsumer((String)consumerGroup);
                        }
                        catch (Exception e) {
                            if (!log.isErrorEnabled()) break block2;
                            log.error("Error in restarting EventMeshConsumer [{}]", consumerGroup, (Object)e);
                        }
                    }
                });
            }, 10000L, 10000L, TimeUnit.MILLISECONDS);
        }
    }

    public List<String> getAllConsumerTopic() {
        return this.clientTable.values().stream().flatMap(Collection::stream).map(ConsumerGroupClient::getTopic).distinct().collect(Collectors.toList());
    }
}

