/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import com.fasterxml.jackson.core.type.TypeReference;
import io.cloudevents.CloudEvent;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.http.HttpEventWrapper;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.boot.HTTPTrace;
import org.apache.eventmesh.runtime.common.EventMeshTrace;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.processor.AsyncHttpProcessor;
import org.apache.eventmesh.runtime.core.protocol.http.processor.HttpProcessor;
import org.apache.eventmesh.runtime.metrics.http.HTTPMetricsServer;
import org.apache.eventmesh.runtime.util.HttpResponseUtils;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerService {
    private static final Logger log = LoggerFactory.getLogger(HandlerService.class);
    private final Logger httpLogger = LoggerFactory.getLogger((String)"http");
    private final Map<String, ProcessorWrapper> httpProcessorMap = new ConcurrentHashMap<String, ProcessorWrapper>();
    private HTTPMetricsServer metrics;
    private HTTPTrace httpTrace;
    public DefaultHttpDataFactory defaultHttpDataFactory = new DefaultHttpDataFactory(false);

    public void init() {
        log.info("HandlerService start ");
    }

    public void register(HttpProcessor httpProcessor, ThreadPoolExecutor threadPoolExecutor) {
        for (String path : httpProcessor.paths()) {
            this.register(path, httpProcessor, threadPoolExecutor);
        }
    }

    public void register(String path, HttpProcessor httpProcessor, ThreadPoolExecutor threadPoolExecutor) {
        if (this.httpProcessorMap.containsKey(path)) {
            throw new RuntimeException(String.format("HandlerService path %s repeat, repeat processor is %s ", path, httpProcessor.getClass().getSimpleName()));
        }
        ProcessorWrapper processorWrapper = new ProcessorWrapper();
        processorWrapper.threadPoolExecutor = threadPoolExecutor;
        if (httpProcessor instanceof AsyncHttpProcessor) {
            processorWrapper.async = (AsyncHttpProcessor)httpProcessor;
        }
        processorWrapper.httpProcessor = httpProcessor;
        processorWrapper.traceEnabled = httpProcessor.getClass().getAnnotation(EventMeshTrace.class).isEnable();
        this.httpProcessorMap.put(path, processorWrapper);
        log.info("path is {}  processor name is {}", (Object)path, (Object)httpProcessor.getClass().getSimpleName());
    }

    public boolean isProcessorWrapper(HttpRequest httpRequest) {
        return Objects.nonNull(this.getProcessorWrapper(httpRequest));
    }

    private ProcessorWrapper getProcessorWrapper(HttpRequest httpRequest) {
        String uri = httpRequest.uri();
        for (Map.Entry<String, ProcessorWrapper> e : this.httpProcessorMap.entrySet()) {
            if (!uri.startsWith(e.getKey())) continue;
            return e.getValue();
        }
        return null;
    }

    public void handler(ChannelHandlerContext ctx, HttpRequest httpRequest, ThreadPoolExecutor asyncContextCompleteHandler) {
        ProcessorWrapper processorWrapper = this.getProcessorWrapper(httpRequest);
        if (Objects.isNull(processorWrapper)) {
            this.sendResponse(ctx, httpRequest, HttpResponseUtils.createNotFound());
            return;
        }
        HTTPTrace.TraceOperation traceOperation = this.httpTrace.getTraceOperation(httpRequest, ctx.channel(), processorWrapper.traceEnabled);
        try {
            HandlerSpecific handlerSpecific = new HandlerSpecific();
            handlerSpecific.request = httpRequest;
            handlerSpecific.ctx = ctx;
            handlerSpecific.traceOperation = traceOperation;
            handlerSpecific.asyncContext = new AsyncContext<Object>(new HttpEventWrapper(), null, asyncContextCompleteHandler);
            processorWrapper.threadPoolExecutor.execute(handlerSpecific);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.sendResponse(ctx, httpRequest, HttpResponseUtils.createInternalServerError());
        }
    }

    private void sendResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        this.sendResponse(ctx, request, response, true);
    }

    private void sendResponse(ChannelHandlerContext ctx, HttpRequest httpRequest, HttpResponse response, boolean isClose) {
        ReferenceCountUtil.release((Object)httpRequest);
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)((ChannelFutureListener)f -> {
            if (!f.isSuccess()) {
                this.httpLogger.warn("send response to [{}] fail, will close this channel", (Object)RemotingHelper.parseChannelRemoteAddr(f.channel()));
                if (isClose) {
                    f.channel().close();
                }
            }
        }));
    }

    private HttpEventWrapper parseHttpRequest(HttpRequest httpRequest) throws IOException {
        HttpEventWrapper httpEventWrapper = new HttpEventWrapper();
        httpEventWrapper.setHttpMethod(httpRequest.method().name());
        httpEventWrapper.setHttpVersion(httpRequest.protocolVersion().protocolName());
        httpEventWrapper.setRequestURI(httpRequest.uri());
        for (String key2 : httpRequest.headers().names()) {
            httpEventWrapper.getHeaderMap().put(key2, httpRequest.headers().get(key2));
        }
        long bodyDecodeStart = System.currentTimeMillis();
        FullHttpRequest fullHttpRequest = (FullHttpRequest)httpRequest;
        HashMap<String, String> bodyMap = new HashMap<String, String>();
        if (HttpMethod.GET == fullHttpRequest.method()) {
            QueryStringDecoder getDecoder = new QueryStringDecoder(fullHttpRequest.uri());
            getDecoder.parameters().forEach((key, value) -> bodyMap.put((String)key, (String)value.get(0)));
        } else if (HttpMethod.POST == fullHttpRequest.method()) {
            if (StringUtils.contains((CharSequence)httpRequest.headers().get("Content-Type"), (CharSequence)ContentType.APPLICATION_JSON.getMimeType())) {
                int length = fullHttpRequest.content().readableBytes();
                if (length > 0) {
                    byte[] body = new byte[length];
                    fullHttpRequest.content().readBytes(body);
                    Optional.ofNullable(JsonUtils.parseTypeReferenceObject((String)new String(body, Constants.DEFAULT_CHARSET), (TypeReference)new TypeReference<Map<String, Object>>(){})).ifPresent(bodyMap::putAll);
                }
            } else {
                HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)this.defaultHttpDataFactory, httpRequest);
                for (InterfaceHttpData parm : decoder.getBodyHttpDatas()) {
                    if (parm.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
                    Attribute data = (Attribute)parm;
                    bodyMap.put(data.getName(), data.getValue());
                }
                decoder.destroy();
            }
        } else {
            throw new RuntimeException("UnSupported Method " + fullHttpRequest.method());
        }
        byte[] requestBody = Optional.ofNullable(JsonUtils.toJSONString(bodyMap)).map(s -> s.getBytes(StandardCharsets.UTF_8)).orElse(new byte[0]);
        httpEventWrapper.setBody(requestBody);
        this.metrics.getSummaryMetrics().recordDecodeTimeCost(System.currentTimeMillis() - bodyDecodeStart);
        return httpEventWrapper;
    }

    public void setMetrics(HTTPMetricsServer metrics) {
        this.metrics = metrics;
    }

    public void setHttpTrace(HTTPTrace httpTrace) {
        this.httpTrace = httpTrace;
    }

    private static class ProcessorWrapper {
        private ThreadPoolExecutor threadPoolExecutor;
        private HttpProcessor httpProcessor;
        private AsyncHttpProcessor async;
        private boolean traceEnabled;

        private ProcessorWrapper() {
        }
    }

    class HandlerSpecific
    implements Runnable {
        private HTTPTrace.TraceOperation traceOperation;
        private ChannelHandlerContext ctx;
        private HttpRequest request;
        private HttpResponse response;
        private AsyncContext<HttpEventWrapper> asyncContext;
        private Throwable exception;
        long requestTime = System.currentTimeMillis();
        private Map<String, Object> traceMap;
        private CloudEvent ce;

        HandlerSpecific() {
        }

        @Override
        public void run() {
            String processorKey = "/";
            for (String eventProcessorKey : HandlerService.this.httpProcessorMap.keySet()) {
                if (!this.request.uri().startsWith(eventProcessorKey)) continue;
                processorKey = eventProcessorKey;
                break;
            }
            ProcessorWrapper processorWrapper = (ProcessorWrapper)HandlerService.this.httpProcessorMap.get(processorKey);
            try {
                this.preHandler();
                if (processorWrapper.httpProcessor instanceof AsyncHttpProcessor) {
                    HttpEventWrapper httpEventWrapper = HandlerService.this.parseHttpRequest(this.request);
                    this.asyncContext.setRequest(httpEventWrapper);
                    processorWrapper.async.handler(this, this.request);
                    return;
                }
                this.response = processorWrapper.httpProcessor.handler(this.request);
                this.postHandler();
            }
            catch (Throwable e) {
                this.exception = e;
                this.response = HttpResponseUtils.createInternalServerError();
                this.error();
            }
        }

        private void postHandler() {
            HandlerService.this.metrics.getSummaryMetrics().recordHTTPRequest();
            if (HandlerService.this.httpLogger.isDebugEnabled()) {
                HandlerService.this.httpLogger.debug("{}", (Object)this.request);
            }
            if (Objects.isNull(this.response)) {
                this.response = HttpResponseUtils.createSuccess();
            }
            this.traceOperation.endTrace(this.ce);
            HandlerService.this.sendResponse(this.ctx, this.request, this.response);
        }

        private void preHandler() {
            HandlerService.this.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - this.requestTime);
            if (HandlerService.this.httpLogger.isDebugEnabled()) {
                HandlerService.this.httpLogger.debug("{}", (Object)this.response);
            }
        }

        private void error() {
            log.error(this.exception.getMessage(), this.exception);
            this.traceOperation.exceptionTrace(this.exception, this.traceMap);
            HandlerService.this.metrics.getSummaryMetrics().recordHTTPDiscard();
            HandlerService.this.metrics.getSummaryMetrics().recordHTTPReqResTimeCost(System.currentTimeMillis() - this.requestTime);
            HandlerService.this.sendResponse(this.ctx, this.request, this.response);
        }

        public void setResponseJsonBody(String body) {
            this.sendResponse(HttpResponseUtils.setResponseJsonBody(body, this.ctx));
        }

        public void setResponseTextBody(String body) {
            this.sendResponse(HttpResponseUtils.setResponseTextBody(body, this.ctx));
        }

        public void sendResponse(HttpResponse response) {
            this.response = response;
            this.postHandler();
        }

        public void sendResponse(Map<String, Object> responseHeaderMap, Map<String, Object> responseBodyMap) {
            try {
                HttpEventWrapper responseWrapper = this.asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
                this.asyncContext.onComplete(responseWrapper);
                this.response = this.asyncContext.getResponse().httpResponse();
                this.postHandler();
            }
            catch (Exception e) {
                this.exception = e;
                this.response = HttpResponseUtils.createInternalServerError();
                this.error();
            }
        }

        public void sendErrorResponse(EventMeshRetCode retCode, Map<String, Object> responseHeaderMap, Map<String, Object> responseBodyMap, Map<String, Object> traceMap) {
            this.traceMap = traceMap;
            try {
                responseBodyMap.put("retCode", retCode.getRetCode());
                responseBodyMap.put("retMsg", retCode.getErrMsg());
                HttpEventWrapper responseWrapper = this.asyncContext.getRequest().createHttpResponse(responseHeaderMap, responseBodyMap);
                this.asyncContext.onComplete(responseWrapper);
                this.exception = new RuntimeException(retCode.getErrMsg());
                this.response = this.asyncContext.getResponse().httpResponse();
                this.error();
            }
            catch (Exception e) {
                this.exception = e;
                this.response = HttpResponseUtils.createInternalServerError();
                this.error();
            }
        }

        public void recordSendBatchMsgFailed(int count) {
            HandlerService.this.metrics.getSummaryMetrics().recordSendBatchMsgFailed(1L);
        }

        public HTTPTrace.TraceOperation getTraceOperation() {
            return this.traceOperation;
        }

        public ChannelHandlerContext getCtx() {
            return this.ctx;
        }

        public HttpRequest getRequest() {
            return this.request;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public AsyncContext<HttpEventWrapper> getAsyncContext() {
            return this.asyncContext;
        }

        public Throwable getException() {
            return this.exception;
        }

        public long getRequestTime() {
            return this.requestTime;
        }

        public Map<String, Object> getTraceMap() {
            return this.traceMap;
        }

        public CloudEvent getCe() {
            return this.ce;
        }

        public void setTraceOperation(HTTPTrace.TraceOperation traceOperation) {
            this.traceOperation = traceOperation;
        }

        public void setCtx(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        public void setRequest(HttpRequest request) {
            this.request = request;
        }

        public void setResponse(HttpResponse response) {
            this.response = response;
        }

        public void setAsyncContext(AsyncContext<HttpEventWrapper> asyncContext) {
            this.asyncContext = asyncContext;
        }

        public void setException(Throwable exception) {
            this.exception = exception;
        }

        public void setRequestTime(long requestTime) {
            this.requestTime = requestTime;
        }

        public void setTraceMap(Map<String, Object> traceMap) {
            this.traceMap = traceMap;
        }

        public void setCe(CloudEvent ce) {
            this.ce = ce;
        }
    }
}

