/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.processor;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.http.HttpCommand;
import org.apache.eventmesh.common.protocol.http.body.client.SubscribeRequestBody;
import org.apache.eventmesh.common.protocol.http.body.client.SubscribeResponseBody;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.RequestCode;
import org.apache.eventmesh.common.protocol.http.header.client.SubscribeRequestHeader;
import org.apache.eventmesh.common.protocol.http.header.client.SubscribeResponseHeader;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.metrics.api.model.HttpSummaryMetrics;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.configuration.EventMeshHTTPConfiguration;
import org.apache.eventmesh.runtime.core.consumer.ClientInfo;
import org.apache.eventmesh.runtime.core.consumer.SubscriptionManager;
import org.apache.eventmesh.runtime.core.protocol.http.async.AsyncContext;
import org.apache.eventmesh.runtime.core.protocol.http.async.CompleteHandler;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.Client;
import org.apache.eventmesh.runtime.core.protocol.http.processor.inf.HttpRequestProcessor;
import org.apache.eventmesh.runtime.util.EventMeshUtil;
import org.apache.eventmesh.runtime.util.RemotingHelper;
import org.apache.eventmesh.runtime.util.WebhookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeProcessor
implements HttpRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(SubscribeProcessor.class);
    private final transient EventMeshHTTPServer eventMeshHTTPServer;
    private final Acl acl;

    public SubscribeProcessor(EventMeshHTTPServer eventMeshHTTPServer) {
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.acl = eventMeshHTTPServer.getAcl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(ChannelHandlerContext ctx, AsyncContext<HttpCommand> asyncContext) throws Exception {
        HttpCommand request = asyncContext.getRequest();
        Integer requestCode = Integer.valueOf(request.getRequestCode());
        String localAddress = IPUtils.getLocalAddress();
        String remoteAddr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
        if (log.isInfoEnabled()) {
            log.info("cmd={}|{}|client2eventMesh|from={}|to={}", new Object[]{RequestCode.get((Integer)requestCode), "http", remoteAddr, localAddress});
        }
        SubscribeRequestHeader subscribeRequestHeader = (SubscribeRequestHeader)request.getHeader();
        SubscribeRequestBody subscribeRequestBody = (SubscribeRequestBody)request.getBody();
        EventMeshHTTPConfiguration eventMeshHttpConfiguration = this.eventMeshHTTPServer.getEventMeshHttpConfiguration();
        SubscribeResponseHeader subscribeResponseHeader = SubscribeResponseHeader.buildHeader((Integer)requestCode, (String)eventMeshHttpConfiguration.getEventMeshCluster(), (String)localAddress, (String)eventMeshHttpConfiguration.getEventMeshEnv(), (String)eventMeshHttpConfiguration.getEventMeshIDC());
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{subscribeRequestHeader.getIdc(), subscribeRequestHeader.getPid(), subscribeRequestHeader.getSys()}) || !StringUtils.isNumeric((CharSequence)subscribeRequestHeader.getPid())) {
            this.completeResponse(request, asyncContext, subscribeResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_HEADER_ERR, null, SubscribeResponseBody.class);
            return;
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{subscribeRequestBody.getUrl(), subscribeRequestBody.getConsumerGroup()}) || CollectionUtils.isEmpty((Collection)subscribeRequestBody.getTopics())) {
            this.completeResponse(request, asyncContext, subscribeResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, null, SubscribeResponseBody.class);
            return;
        }
        List subTopicList = subscribeRequestBody.getTopics();
        if (eventMeshHttpConfiguration.isEventMeshServerSecurityEnable()) {
            for (SubscriptionItem item : subTopicList) {
                try {
                    this.acl.doAclCheckInHttpReceive(remoteAddr, subscribeRequestHeader.getUsername(), subscribeRequestHeader.getPasswd(), subscribeRequestHeader.getSys(), item.getTopic(), requestCode);
                }
                catch (Exception e) {
                    this.completeResponse(request, asyncContext, subscribeResponseHeader, EventMeshRetCode.EVENTMESH_ACL_ERR, e.getMessage(), SubscribeResponseBody.class);
                    if (log.isWarnEnabled()) {
                        log.warn("CLIENT HAS NO PERMISSION,SubscribeProcessor subscribe failed", (Throwable)e);
                    }
                    return;
                }
            }
        }
        String url = subscribeRequestBody.getUrl();
        String consumerGroup = subscribeRequestBody.getConsumerGroup();
        try {
            if (!IPUtils.isValidDomainOrIp((String)url, eventMeshHttpConfiguration.getEventMeshIpv4BlackList(), eventMeshHttpConfiguration.getEventMeshIpv6BlackList())) {
                log.error("subscriber url {} is not valid", (Object)url);
                this.completeResponse(request, asyncContext, subscribeResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg() + " invalid URL: " + url, SubscribeResponseBody.class);
                return;
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error("subscriber url:{} is invalid.", (Object)url, (Object)e);
            }
            this.completeResponse(request, asyncContext, subscribeResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg() + " invalid URL: " + url, SubscribeResponseBody.class);
            return;
        }
        if (!WebhookUtil.obtainDeliveryAgreement(this.eventMeshHTTPServer.getHttpClientPool().getClient(), url, eventMeshHttpConfiguration.getEventMeshWebhookOrigin())) {
            log.error("subscriber url {} is not allowed by the target system", (Object)url);
            this.completeResponse(request, asyncContext, subscribeResponseHeader, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR, EventMeshRetCode.EVENTMESH_PROTOCOL_BODY_ERR.getErrMsg() + " unauthorized webhook URL: " + url, SubscribeResponseBody.class);
            return;
        }
        SubscriptionManager subscriptionManager = this.eventMeshHTTPServer.getSubscriptionManager();
        ConcurrentHashMap<String, List<Client>> concurrentHashMap = subscriptionManager.getLocalClientInfoMapping();
        synchronized (concurrentHashMap) {
            ClientInfo clientInfo = this.getClientInfo(subscribeRequestHeader);
            subscriptionManager.registerClient(clientInfo, consumerGroup, subTopicList, url);
            subscriptionManager.updateSubscription(clientInfo, consumerGroup, url, subTopicList);
            long startTime = System.currentTimeMillis();
            HttpSummaryMetrics summaryMetrics = this.eventMeshHTTPServer.getMetrics().getSummaryMetrics();
            try {
                this.eventMeshHTTPServer.getConsumerManager().notifyConsumerManager(consumerGroup, subscriptionManager.getLocalConsumerGroupMapping().get(consumerGroup));
                CompleteHandler<HttpCommand> handler = httpCommand -> {
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("{}", httpCommand);
                        }
                        this.eventMeshHTTPServer.sendResponse(ctx, httpCommand.httpResponse());
                        summaryMetrics.recordHTTPReqResTimeCost(System.currentTimeMillis() - request.getReqTime());
                    }
                    catch (Exception ex) {
                        log.error("onResponse error", (Throwable)ex);
                    }
                };
                HttpCommand responseEventMeshCommand = request.createHttpCommandResponse(EventMeshRetCode.SUCCESS);
                asyncContext.onComplete(responseEventMeshCommand, handler);
            }
            catch (Exception e) {
                this.completeResponse(request, asyncContext, subscribeResponseHeader, EventMeshRetCode.EVENTMESH_SUBSCRIBE_ERR, EventMeshRetCode.EVENTMESH_SUBSCRIBE_ERR.getErrMsg() + EventMeshUtil.stackTrace(e, 2), SubscribeResponseBody.class);
                long endTime = System.currentTimeMillis();
                if (log.isErrorEnabled()) {
                    log.error("message|eventMesh2mq|REQ|ASYNC|send2MQCost={}ms|topic={}|bizSeqNo={}|uniqueId={}", new Object[]{endTime - startTime, JsonUtils.toJSONString((Object)subscribeRequestBody.getTopics()), subscribeRequestBody.getUrl(), e});
                }
                summaryMetrics.recordSendMsgFailed();
                summaryMetrics.recordSendMsgCost(endTime - startTime);
            }
        }
    }

    private ClientInfo getClientInfo(SubscribeRequestHeader subscribeRequestHeader) {
        ClientInfo clientInfo = new ClientInfo();
        clientInfo.setEnv(subscribeRequestHeader.getEnv());
        clientInfo.setIdc(subscribeRequestHeader.getIdc());
        clientInfo.setSys(subscribeRequestHeader.getSys());
        clientInfo.setIp(subscribeRequestHeader.getIp());
        clientInfo.setPid(subscribeRequestHeader.getPid());
        return clientInfo;
    }
}

