/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.aggregator.DoubleHistogramAggregator;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;

final class HistogramAggregatorFactory
implements AggregatorFactory {
    private final double[] boundaries;
    private final AggregationTemporality temporality;

    HistogramAggregatorFactory(List<Double> boundaries, AggregationTemporality temporality) {
        this.boundaries = boundaries.stream().mapToDouble(i -> i).toArray();
        this.temporality = temporality;
        for (double v : this.boundaries) {
            if (!Double.isNaN(v)) continue;
            throw new IllegalArgumentException("invalid bucket boundary: NaN");
        }
        for (int i2 = 1; i2 < this.boundaries.length; ++i2) {
            if (!(this.boundaries[i2 - 1] >= this.boundaries[i2])) continue;
            throw new IllegalArgumentException("invalid bucket boundary: " + this.boundaries[i2 - 1] + " >= " + this.boundaries[i2]);
        }
        if (this.boundaries.length > 0) {
            if (this.boundaries[0] == Double.NEGATIVE_INFINITY) {
                throw new IllegalArgumentException("invalid bucket boundary: -Inf");
            }
            if (this.boundaries[this.boundaries.length - 1] == Double.POSITIVE_INFINITY) {
                throw new IllegalArgumentException("invalid bucket boundary: +Inf");
            }
        }
    }

    @Override
    public <T> Aggregator<T> create(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor) {
        boolean stateful = this.temporality == AggregationTemporality.CUMULATIVE;
        switch (descriptor.getValueType()) {
            case LONG: 
            case DOUBLE: {
                return new DoubleHistogramAggregator(resource, instrumentationLibraryInfo, descriptor, this.boundaries, stateful);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }
}

