/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import io.opentelemetry.api.metrics.common.Labels;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.aggregator.AbstractSumAggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.LongSumData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;

final class LongSumAggregator
extends AbstractSumAggregator<Long> {
    LongSumAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor descriptor, AggregationTemporality temporality) {
        super(resource, instrumentationLibraryInfo, descriptor, temporality);
    }

    @Override
    public AggregatorHandle<Long> createHandle() {
        return new Handle();
    }

    @Override
    public Long accumulateLong(long value) {
        return value;
    }

    @Override
    Long mergeSum(Long previousAccumulation, Long accumulation) {
        return previousAccumulation + accumulation;
    }

    @Override
    Long mergeDiff(Long previousAccumulation, Long accumulation) {
        return accumulation - previousAccumulation;
    }

    @Override
    public MetricData toMetricData(Map<Labels, Long> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        InstrumentDescriptor descriptor = this.getInstrumentDescriptor();
        return MetricData.createLongSum(this.getResource(), this.getInstrumentationLibraryInfo(), descriptor.getName(), descriptor.getDescription(), descriptor.getUnit(), LongSumData.create(this.isMonotonic(), this.temporality(), MetricDataUtils.toLongPointList(accumulationByLabels, this.temporality() == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<Long> {
        private final LongAdder current = new LongAdder();

        Handle() {
        }

        @Override
        protected Long doAccumulateThenReset() {
            return this.current.sumThenReset();
        }

        @Override
        public void doRecordLong(long value) {
            this.current.add(value);
        }
    }
}

