/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.protobuf;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import io.cloudevents.protobuf.ProtoCloudEventData;
import io.cloudevents.protobuf.ProtoSupport;

class ProtoDataWrapper
implements ProtoCloudEventData {
    private final Message protoMessage;

    ProtoDataWrapper(Message protoMessage) {
        this.protoMessage = protoMessage;
    }

    @Override
    public Message getMessage() {
        return this.protoMessage;
    }

    public byte[] toBytes() {
        return this.protoMessage.toByteArray();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProtoDataWrapper)) {
            return false;
        }
        ProtoDataWrapper rhs = (ProtoDataWrapper)obj;
        if (this.getMessage() == rhs.getMessage()) {
            return true;
        }
        Any lhsAny = this.getAsAny(this.getMessage());
        Any rhsAny = this.getAsAny(rhs.getMessage());
        boolean typesMatch = ProtoSupport.extractMessageType(lhsAny).equals(ProtoSupport.extractMessageType(rhsAny));
        if (typesMatch) {
            return lhsAny.getValue().equals((Object)rhsAny.getValue());
        }
        return false;
    }

    private Any getAsAny(Message m) {
        if (m instanceof Any) {
            return (Any)m;
        }
        return Any.pack((Message)m);
    }
}

