/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.spi.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import org.apache.eventmesh.spi.ExtensionException;
import org.apache.eventmesh.spi.loader.ExtensionClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaInfExtensionClassLoader
implements ExtensionClassLoader {
    private static final Logger log = LoggerFactory.getLogger(MetaInfExtensionClassLoader.class);
    private static final MetaInfExtensionClassLoader INSTANCE = new MetaInfExtensionClassLoader();
    private final ConcurrentHashMap<Class<?>, Map<String, Class<?>>> extensionClassCache = new ConcurrentHashMap(16);

    private MetaInfExtensionClassLoader() {
    }

    @Override
    public <T> Map<String, Class<?>> loadExtensionClass(Class<T> extensionType, String extensionInstanceName) {
        return this.extensionClassCache.computeIfAbsent(extensionType, this::doLoadExtensionClass);
    }

    public static MetaInfExtensionClassLoader getInstance() {
        return INSTANCE;
    }

    private <T> Map<String, Class<?>> doLoadExtensionClass(Class<T> extensionType) {
        HashMap extensionMap = new HashMap();
        String extensionFileName = "META-INF/eventmesh/" + extensionType.getName();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> extensionUrls = classLoader.getResources(extensionFileName);
            if (extensionUrls != null) {
                while (extensionUrls.hasMoreElements()) {
                    URL url = extensionUrls.nextElement();
                    extensionMap.putAll(this.loadResources(url, extensionType));
                }
            }
        }
        catch (IOException e) {
            throw new ExtensionException("load extension class error", e);
        }
        return extensionMap;
    }

    private <T> Map<String, Class<?>> loadResources(URL url, Class<T> extensionType) throws IOException {
        HashMap extensionMap = new HashMap();
        try (InputStream inputStream = url.openStream();){
            Properties properties = new Properties();
            properties.load(inputStream);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(extensionName, extensionClass) -> {
                String extensionNameStr = (String)extensionName;
                String extensionClassStr = (String)extensionClass;
                try {
                    Class<?> targetClass = Class.forName(extensionClassStr);
                    log.info("load extension class success, extensionType: {}, extensionClass: {}", (Object)extensionType, targetClass);
                    if (!extensionType.isAssignableFrom(targetClass)) {
                        throw new ExtensionException(String.format("class: %s is not subClass of %s", targetClass, extensionType));
                    }
                    extensionMap.put(extensionNameStr, targetClass);
                }
                catch (ClassNotFoundException e) {
                    throw new ExtensionException("load extension class error", e);
                }
            }));
        }
        return extensionMap;
    }
}

