/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.utils;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;

public class PropertiesUtils {
    public static Properties getPropertiesByPrefix(Properties from, String prefix) {
        Properties to = new Properties();
        if (StringUtils.isBlank((CharSequence)prefix) || from == null) {
            return to;
        }
        from.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String realKey;
            String[] hierarchicalKeys;
            String keyStr = String.valueOf(key);
            if (StringUtils.startsWith((CharSequence)keyStr, (CharSequence)prefix) && (hierarchicalKeys = StringUtils.split((String)(realKey = StringUtils.substring((String)keyStr, (int)prefix.length())), (String)".")) != null) {
                Properties hierarchical = to;
                for (int idx = 0; idx < hierarchicalKeys.length; ++idx) {
                    String hierarchicalKey = hierarchicalKeys[idx];
                    if (StringUtils.isBlank((CharSequence)hierarchicalKey)) {
                        return;
                    }
                    if (idx < hierarchicalKeys.length - 1) {
                        Object pending = hierarchical.get(hierarchicalKey);
                        if (pending == null) {
                            Properties properties = hierarchical;
                            hierarchical = new Properties();
                            properties.put(hierarchicalKey, hierarchical);
                            continue;
                        }
                        if (pending instanceof Properties) {
                            hierarchical = (Properties)pending;
                            continue;
                        }
                        return;
                    }
                    hierarchical.put(hierarchicalKey, value);
                }
            }
        }));
        return to;
    }

    public static void loadPropertiesWhenFileExist(Properties properties, String path, Charset cs) throws IOException {
        Preconditions.checkNotNull((Object)properties, (Object)"Properties can not be null");
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), cs));){
            properties.load(reader);
        }
    }

    public static void loadPropertiesWhenFileExist(Properties properties, String path) throws IOException {
        PropertiesUtils.loadPropertiesWhenFileExist(properties, path, StandardCharsets.UTF_8);
    }
}

