/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.utils;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.enums.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);

    public static Map<String, String> formData2Dic(String formData) {
        if (StringUtils.isBlank((CharSequence)formData)) {
            return new HashMap<String, String>();
        }
        String[] items = formData.split("&");
        HashMap<String, String> result = new HashMap<String, String>(items.length);
        Arrays.stream(items).forEach(item -> {
            String[] keyAndVal = item.split("=");
            if (keyAndVal.length == 2) {
                try {
                    String key = URLDecoder.decode(keyAndVal[0], Constants.DEFAULT_CHARSET.name());
                    String val = URLDecoder.decode(keyAndVal[1], Constants.DEFAULT_CHARSET.name());
                    result.put(key, val);
                }
                catch (UnsupportedEncodingException e) {
                    log.warn("formData2Dic:param decode failed...", (Throwable)e);
                }
            }
        });
        return result;
    }

    public static String addressToString(List<InetSocketAddress> clients) {
        if (clients.isEmpty()) {
            return "no session had been closed";
        }
        StringBuilder sb = new StringBuilder();
        for (InetSocketAddress addr : clients) {
            sb.append(addr).append("|");
        }
        return sb.toString();
    }

    public static String parsePostBody(HttpExchange exchange) throws IOException {
        if (!HttpMethod.POST.name().equalsIgnoreCase(exchange.getRequestMethod()) && !HttpMethod.PUT.name().equalsIgnoreCase(exchange.getRequestMethod())) {
            return "";
        }
        StringBuilder body = new StringBuilder(1024);
        try (InputStreamReader reader = new InputStreamReader(exchange.getRequestBody(), Constants.DEFAULT_CHARSET.name());){
            int readIndex;
            char[] buffer = new char[256];
            while ((readIndex = reader.read(buffer)) != -1) {
                body.append(buffer, 0, readIndex);
            }
        }
        return body.toString();
    }

    public static void sendSuccessResponseHeaders(HttpExchange httpExchange) throws IOException {
        httpExchange.sendResponseHeaders(200, 0L);
    }
}

