/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.grpc.channelz;

import java.net.InetSocketAddress;
import java.util.Set;

public interface ChannelzRegistry {
    public void addSocket(long var1, InetSocketAddress var3, InetSocketAddress var4);

    public Long removeSocket(InetSocketAddress var1);

    public Set<Long> getSocketLogId(AddressId var1);

    public void addServer(long var1, String var3);

    public Long getServerLogId(String var1);

    public static class AddressId {
        private final String address;
        private final int port;

        public static AddressId newAddressId(String address, int port) {
            return new AddressId(address, port);
        }

        public static AddressId newAddressId(InetSocketAddress local, InetSocketAddress remote) {
            return new AddressId(remote.getHostString(), local.getPort());
        }

        private AddressId(String address, int localPort) {
            this.address = address;
            this.port = localPort;
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddressId addressId = (AddressId)o;
            if (this.port != addressId.port) {
                return false;
            }
            return this.address != null ? this.address.equals(addressId.address) : addressId.address == null;
        }

        public int hashCode() {
            int result = this.port;
            result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
            return result;
        }
    }
}

