/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.navercorp.pinpoint.grpc.server.MetadataServerTransportFilter;
import io.grpc.Attributes;
import io.grpc.Metadata;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerTransportListener;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogIdAttachListener
implements ServerTransportListener {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ServerTransportListener delegate;
    private final Long logId;

    public LogIdAttachListener(ServerTransportListener delegate, Long logId) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.logId = Objects.requireNonNull(logId, "logId");
    }

    public void streamCreated(ServerStream stream, String method, Metadata headers) {
        this.delegate.streamCreated(stream, method, headers);
    }

    public Attributes transportReady(Attributes attributes) {
        Attributes.Builder builder = attributes.toBuilder();
        builder.set(MetadataServerTransportFilter.LOG_ID, (Object)this.logId);
        Attributes build = builder.build();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("logId:{} transportReady:{} ", (Object)this.logId, (Object)attributes);
        }
        return this.delegate.transportReady(build);
    }

    public void transportTerminated() {
        this.delegate.transportTerminated();
    }
}

