/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.standalone.consumer;

import io.cloudevents.CloudEvent;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.AbstractContext;
import org.apache.eventmesh.api.EventListener;
import org.apache.eventmesh.api.consumer.Consumer;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.storage.standalone.broker.StandaloneBroker;
import org.apache.eventmesh.storage.standalone.broker.model.TopicMetadata;
import org.apache.eventmesh.storage.standalone.broker.task.Subscribe;
import org.apache.eventmesh.storage.standalone.broker.task.SubscribeTask;

public class StandaloneConsumer
implements Consumer {
    private final StandaloneBroker standaloneBroker = StandaloneBroker.getInstance();
    private EventListener listener;
    private final AtomicBoolean isStarted;
    private final ConcurrentHashMap<String, Subscribe> subscribeTable = new ConcurrentHashMap(16);
    private final ExecutorService consumeExecutorService;

    public StandaloneConsumer(Properties properties) {
        this.isStarted = new AtomicBoolean(false);
        this.consumeExecutorService = ThreadPoolFactory.createThreadPoolExecutor((int)(Runtime.getRuntime().availableProcessors() * 2), (int)(Runtime.getRuntime().availableProcessors() * 2), (String)"StandaloneConsumerThread");
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    public boolean isClosed() {
        return !this.isStarted.get();
    }

    public void start() {
        this.isStarted.compareAndSet(false, true);
    }

    public void shutdown() {
        this.isStarted.compareAndSet(true, false);
        this.subscribeTable.forEach((topic, subScribe) -> subScribe.shutdown());
        this.subscribeTable.clear();
    }

    public void init(Properties keyValue) throws Exception {
    }

    public void updateOffset(List<CloudEvent> cloudEvents, AbstractContext context) {
        cloudEvents.forEach(cloudEvent -> this.standaloneBroker.updateOffset(new TopicMetadata(cloudEvent.getSubject()), Objects.requireNonNull((Long)cloudEvent.getExtension("offset"))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String topic) throws Exception {
        if (this.subscribeTable.containsKey(topic)) {
            return;
        }
        ConcurrentHashMap<String, Subscribe> concurrentHashMap = this.subscribeTable;
        synchronized (concurrentHashMap) {
            this.standaloneBroker.createTopicIfAbsent(topic);
            Subscribe subscribe = new Subscribe(topic, this.standaloneBroker, this.listener);
            SubscribeTask subScribeTask = new SubscribeTask(subscribe);
            this.subscribeTable.put(topic, subscribe);
            this.consumeExecutorService.execute(subScribeTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(String topic) {
        if (!this.subscribeTable.containsKey(topic)) {
            return;
        }
        ConcurrentHashMap<String, Subscribe> concurrentHashMap = this.subscribeTable;
        synchronized (concurrentHashMap) {
            Subscribe subScribe = this.subscribeTable.get(topic);
            subScribe.shutdown();
            this.subscribeTable.remove(topic);
        }
    }

    public void registerEventListener(EventListener listener) {
        this.listener = listener;
    }
}

