/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.commands;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.karaf.shell.console.OsgiCommandSupport;
import org.fusesource.jansi.Ansi;

@Command(scope="shell", name="info", description="Prints system informations")
public class InfoAction
extends OsgiCommandSupport {
    private NumberFormat fmtI = new DecimalFormat("###,###", new DecimalFormatSymbols(Locale.ENGLISH));
    private NumberFormat fmtD = new DecimalFormat("###,##0.000", new DecimalFormatSymbols(Locale.ENGLISH));

    protected Object doExecute() throws Exception {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        OperatingSystemMXBean os = ManagementFactory.getOperatingSystemMXBean();
        ThreadMXBean threads = ManagementFactory.getThreadMXBean();
        MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
        ClassLoadingMXBean cl = ManagementFactory.getClassLoadingMXBean();
        int maxNameLen = 25;
        System.out.println("Karaf");
        this.printValue("Karaf home", maxNameLen, System.getProperty("karaf.home"));
        this.printValue("Karaf base", maxNameLen, System.getProperty("karaf.base"));
        this.printValue("OSGi Framework", maxNameLen, this.bundleContext.getBundle(0L).getSymbolicName() + " - " + this.bundleContext.getBundle(0L).getVersion());
        System.out.println();
        System.out.println("JVM");
        this.printValue("Java Virtual Machine", maxNameLen, runtime.getVmName() + " version " + runtime.getVmVersion());
        this.printValue("Vendor", maxNameLen, runtime.getVmVendor());
        this.printValue("Uptime", maxNameLen, this.printDuration(runtime.getUptime()));
        try {
            this.printValue("Process CPU time", maxNameLen, this.printDuration(this.getSunOsValueAsLong(os, "getProcessCpuTime") / 1000000L));
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.printValue("Total compile time", maxNameLen, this.printDuration(ManagementFactory.getCompilationMXBean().getTotalCompilationTime()));
        System.out.println("Threads");
        this.printValue("Live threads", maxNameLen, Integer.toString(threads.getThreadCount()));
        this.printValue("Daemon threads", maxNameLen, Integer.toString(threads.getDaemonThreadCount()));
        this.printValue("Peak", maxNameLen, Integer.toString(threads.getPeakThreadCount()));
        this.printValue("Total started", maxNameLen, Long.toString(threads.getTotalStartedThreadCount()));
        System.out.println("Memory");
        this.printValue("Current heap size", maxNameLen, this.printSizeInKb(mem.getHeapMemoryUsage().getUsed()));
        this.printValue("Maximum heap size", maxNameLen, this.printSizeInKb(mem.getHeapMemoryUsage().getMax()));
        this.printValue("Committed heap size", maxNameLen, this.printSizeInKb(mem.getHeapMemoryUsage().getCommitted()));
        this.printValue("Pending objects", maxNameLen, Integer.toString(mem.getObjectPendingFinalizationCount()));
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            String val = "Name = '" + gc.getName() + "', Collections = " + gc.getCollectionCount() + ", Time = " + this.printDuration(gc.getCollectionTime());
            this.printValue("Garbage collector", maxNameLen, val);
        }
        System.out.println("Classes");
        this.printValue("Current classes loaded", maxNameLen, this.printLong(cl.getLoadedClassCount()));
        this.printValue("Total classes loaded", maxNameLen, this.printLong(cl.getTotalLoadedClassCount()));
        this.printValue("Total classes unloaded", maxNameLen, this.printLong(cl.getUnloadedClassCount()));
        System.out.println("Operating system");
        this.printValue("Name", maxNameLen, os.getName() + " version " + os.getVersion());
        this.printValue("Architecture", maxNameLen, os.getArch());
        this.printValue("Processors", maxNameLen, Integer.toString(os.getAvailableProcessors()));
        try {
            this.printValue("Total physical memory", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(os, "getTotalPhysicalMemorySize")));
            this.printValue("Free physical memory", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(os, "getFreePhysicalMemorySize")));
            this.printValue("Committed virtual memory", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(os, "getCommittedVirtualMemorySize")));
            this.printValue("Total swap space", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(os, "getTotalSwapSpaceSize")));
            this.printValue("Free swap space", maxNameLen, this.printSizeInKb(this.getSunOsValueAsLong(os, "getFreeSwapSpaceSize")));
        }
        catch (Throwable t) {
            // empty catch block
        }
        return null;
    }

    private long getSunOsValueAsLong(OperatingSystemMXBean os, String name) throws Exception {
        Method mth = os.getClass().getMethod(name, new Class[0]);
        return (Long)mth.invoke((Object)os, new Object[0]);
    }

    private String printLong(long i) {
        return this.fmtI.format(i);
    }

    private String printSizeInKb(double size) {
        return this.fmtI.format((long)(size / 1024.0)) + " kbytes";
    }

    private String printDuration(double uptime) {
        if ((uptime /= 1000.0) < 60.0) {
            return this.fmtD.format(uptime) + " seconds";
        }
        if ((uptime /= 60.0) < 60.0) {
            long minutes = (long)uptime;
            String s = this.fmtI.format(minutes) + (minutes > 1L ? " minutes" : " minute");
            return s;
        }
        if ((uptime /= 60.0) < 24.0) {
            long hours = (long)uptime;
            long minutes = (long)((uptime - (double)hours) * 60.0);
            String s = this.fmtI.format(hours) + (hours > 1L ? " hours" : " hour");
            if (minutes != 0L) {
                s = s + " " + this.fmtI.format(minutes) + (minutes > 1L ? " minutes" : "minute");
            }
            return s;
        }
        long days = (long)(uptime /= 24.0);
        long hours = (long)((uptime - (double)days) * 60.0);
        String s = this.fmtI.format(days) + (days > 1L ? " days" : " day");
        if (hours != 0L) {
            s = s + " " + this.fmtI.format(hours) + (hours > 1L ? " hours" : "hour");
        }
        return s;
    }

    void printSysValue(String prop, int pad) {
        this.printValue(prop, pad, System.getProperty(prop));
    }

    void printValue(String name, int pad, String value) {
        System.out.println(Ansi.ansi().a("  ").a(Ansi.Attribute.INTENSITY_BOLD).a(name).a(this.spaces(pad - name.length())).a(Ansi.Attribute.RESET).a("   ").a(value).toString());
    }

    String spaces(int nb) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nb; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

