/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.main;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.felix.karaf.main.BootstrapLogManager;
import org.apache.felix.karaf.main.Lock;

public class SimpleFileLock
implements Lock {
    private static final Logger LOG = Logger.getLogger(SimpleFileLock.class.getName());
    private static final String PROPERTY_LOCK_DIR = "karaf.lock.dir";
    private static final String PROP_KARAF_BASE = "karaf.base";
    private RandomAccessFile lockFile;
    private FileLock lock;

    public SimpleFileLock(Properties props) {
        try {
            LOG.addHandler(BootstrapLogManager.getDefaultHandler());
            String lock = props.getProperty(PROPERTY_LOCK_DIR);
            if (lock != null) {
                File karafLock = SimpleFileLock.getKarafLock(new File(lock), props);
                props.setProperty(PROPERTY_LOCK_DIR, karafLock.getPath());
            } else {
                props.setProperty(PROPERTY_LOCK_DIR, System.getProperty(PROP_KARAF_BASE));
            }
            File base = new File(props.getProperty(PROPERTY_LOCK_DIR));
            this.lockFile = new RandomAccessFile(new File(base, "lock"), "rw");
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create file lock", e);
        }
    }

    public boolean lock() throws Exception {
        LOG.info("locking");
        if (this.lock == null) {
            this.lock = this.lockFile.getChannel().tryLock();
        }
        return this.lock != null;
    }

    public void release() throws Exception {
        LOG.info("releasing");
        if (this.lock != null && this.lock.isValid()) {
            this.lock.release();
            this.lock.channel().close();
        }
        this.lock = null;
    }

    public boolean isAlive() throws Exception {
        return this.lock != null;
    }

    private static File getKarafLock(File lock, Properties props) {
        File rc = null;
        String path = lock.getPath();
        if (path != null) {
            rc = SimpleFileLock.validateDirectoryExists(path, "Invalid karaf.lock.dir system property");
        }
        if (rc == null && (path = props.getProperty(PROP_KARAF_BASE)) != null) {
            rc = SimpleFileLock.validateDirectoryExists(path, "Invalid karaf.base property");
        }
        if (rc == null) {
            rc = lock;
        }
        return rc;
    }

    private static File validateDirectoryExists(String path, String errPrefix) {
        File rc;
        try {
            rc = new File(path).getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : " + e.getMessage());
        }
        if (!rc.exists()) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : does not exist");
        }
        if (!rc.isDirectory()) {
            throw new IllegalArgumentException(errPrefix + " '" + path + "' : is not a directory");
        }
        return rc;
    }
}

