/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jline.Terminal;
import org.apache.sshd.common.PtyMode;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.SignalListener;

public class SshTerminal
extends Terminal
implements SignalListener {
    public static final short ARROW_START = 27;
    public static final short ARROW_PREFIX = 91;
    public static final short ARROW_LEFT = 68;
    public static final short ARROW_RIGHT = 67;
    public static final short ARROW_UP = 65;
    public static final short ARROW_DOWN = 66;
    public static final short O_PREFIX = 79;
    public static final short HOME_CODE = 72;
    public static final short END_CODE = 70;
    public static final short DEL_THIRD = 51;
    public static final short DEL_SECOND = 126;
    private Environment environment;
    private boolean backspaceDeleteSwitched = false;
    private String encoding = System.getProperty("input.encoding", "UTF-8");
    private ReplayPrefixOneCharInputStream replayStream = new ReplayPrefixOneCharInputStream(this.encoding);
    private InputStreamReader replayReader;
    private boolean isWindowsTerminal;

    public SshTerminal(Environment environment) {
        this.environment = environment;
        this.environment.addSignalListener((SignalListener)this);
        try {
            this.replayReader = new InputStreamReader((InputStream)this.replayStream, this.encoding);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Integer verase = (Integer)this.environment.getPtyModes().get(PtyMode.VERASE);
        this.backspaceDeleteSwitched = verase != null && verase == 127;
        this.isWindowsTerminal = "windows".equals(environment.getEnv().get("TERM"));
    }

    public void initializeTerminal() throws Exception {
    }

    public void restoreTerminal() throws Exception {
    }

    public boolean isANSISupported() {
        return !this.isWindowsTerminal;
    }

    public int getTerminalWidth() {
        return Integer.valueOf((String)this.environment.getEnv().get("COLUMNS"));
    }

    public int getTerminalHeight() {
        return Integer.valueOf((String)this.environment.getEnv().get("LINES"));
    }

    public boolean isSupported() {
        return true;
    }

    public boolean getEcho() {
        return false;
    }

    public boolean isEchoEnabled() {
        return false;
    }

    public void enableEcho() {
    }

    public void disableEcho() {
    }

    public void signal(Signal signal) {
    }

    public int readVirtualKey(InputStream in) throws IOException {
        int c = this.readCharacter(in);
        if (this.backspaceDeleteSwitched) {
            if (c == 127) {
                c = 8;
            } else if (c == 8) {
                c = 127;
            }
        }
        if (c == 27) {
            while (c == 27) {
                c = this.readCharacter(in);
            }
            if (c == 91 || c == 79) {
                c = this.readCharacter(in);
                if (c == 65) {
                    return 16;
                }
                if (c == 66) {
                    return 14;
                }
                if (c == 68) {
                    return 2;
                }
                if (c == 67) {
                    return 6;
                }
                if (c == 72) {
                    return 1;
                }
                if (c == 70) {
                    return 5;
                }
                if (c == 51) {
                    c = this.readCharacter(in);
                    return 127;
                }
            }
        }
        if (c > 128) {
            this.replayStream.setInput(c, in);
            c = this.replayReader.read();
        }
        return c;
    }

    static class ReplayPrefixOneCharInputStream
    extends InputStream {
        byte firstByte;
        int byteLength;
        InputStream wrappedStream;
        int byteRead;
        final String encoding;

        public ReplayPrefixOneCharInputStream(String encoding) {
            this.encoding = encoding;
        }

        public void setInput(int recorded, InputStream wrapped) throws IOException {
            this.byteRead = 0;
            this.firstByte = (byte)recorded;
            this.wrappedStream = wrapped;
            this.byteLength = 1;
            if (this.encoding.equalsIgnoreCase("UTF-8")) {
                this.setInputUTF8(recorded, wrapped);
            } else if (this.encoding.equalsIgnoreCase("UTF-16")) {
                this.byteLength = 2;
            } else if (this.encoding.equalsIgnoreCase("UTF-32")) {
                this.byteLength = 4;
            }
        }

        public void setInputUTF8(int recorded, InputStream wrapped) throws IOException {
            if ((this.firstByte & 0xFFFFFFE0) == -64) {
                this.byteLength = 2;
            } else if ((this.firstByte & 0xFFFFFFF0) == -32) {
                this.byteLength = 3;
            } else if ((this.firstByte & 0xFFFFFFF8) == -16) {
                this.byteLength = 4;
            } else {
                throw new IOException("invalid UTF-8 first byte: " + this.firstByte);
            }
        }

        public int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            ++this.byteRead;
            if (this.byteRead == 1) {
                return this.firstByte;
            }
            return this.wrappedStream.read();
        }

        public int available() {
            return this.byteLength - this.byteRead;
        }
    }
}

