/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.junit4osgi.plugin;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import junit.framework.Test;
import org.codehaus.plexus.util.StringUtils;

public class Report {
    protected static final String NL = System.getProperty("line.separator");
    protected int m_completedCount;
    protected int m_errorsCount;
    protected int m_failuresCount;
    protected long m_startTime;
    protected long m_endTime;
    private List m_failureSources = new ArrayList();
    private List m_errorSources = new ArrayList();
    private NumberFormat m_numberFormat = NumberFormat.getInstance(Locale.US);

    public List getFailureSources() {
        return this.m_failureSources;
    }

    public List getErrorSources() {
        return this.m_errorSources;
    }

    public void testStarting() {
        this.m_startTime = System.currentTimeMillis();
    }

    public void testSucceeded() {
        this.endTest();
    }

    public void testError(Test test) {
        ++this.m_errorsCount;
        this.m_errorSources.add(test.toString());
        this.endTest();
    }

    public void testFailed(Test test) {
        ++this.m_failuresCount;
        this.m_failureSources.add(test.toString());
        this.endTest();
    }

    private void endTest() {
        ++this.m_completedCount;
        this.m_endTime = System.currentTimeMillis();
        if (this.m_startTime == 0L) {
            this.m_startTime = this.m_endTime;
        }
    }

    public int getNumErrors() {
        return this.m_errorsCount;
    }

    public int getNumFailures() {
        return this.m_failuresCount;
    }

    public int getNumTests() {
        return this.m_completedCount;
    }

    public void reset() {
        this.m_errorsCount = 0;
        this.m_failuresCount = 0;
        this.m_completedCount = 0;
        this.m_failureSources = new ArrayList();
        this.m_errorSources = new ArrayList();
    }

    protected String elapsedTimeAsString(long runTime) {
        return this.m_numberFormat.format((double)runTime / 1000.0);
    }

    protected String getStackTrace(Test test, Throwable e) {
        int i;
        if (e == null) {
            return "";
        }
        StringWriter w = new StringWriter();
        if (e != null) {
            e.printStackTrace(new PrintWriter(w));
            w.flush();
        }
        String text = w.toString();
        String marker = "at " + test.toString();
        String[] lines = StringUtils.split((String)text, (String)"\n");
        int lastLine = lines.length - 1;
        int causedByLine = -1;
        for (int i2 = 1; i2 < lines.length; ++i2) {
            String line = lines[i2].trim();
            if (line.startsWith(marker)) {
                lastLine = i2;
                continue;
            }
            if (!line.startsWith("Caused by")) continue;
            causedByLine = i2;
            break;
        }
        StringBuffer trace = new StringBuffer();
        for (i = 0; i <= lastLine; ++i) {
            trace.append(lines[i]);
            trace.append("\n");
        }
        if (causedByLine != -1) {
            for (i = causedByLine; i < lines.length; ++i) {
                trace.append(lines[i]);
                trace.append("\n");
            }
        }
        return trace.toString();
    }
}

