/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;
import org.apache.felix.utils.json.JSONWriter;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResultJsonSerializer.class})
public class ResultJsonSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(ResultJsonSerializer.class);
    static final String OVERALL_RESULT_KEY = "OverallResult";

    public String serialize(Result overallResult, List<HealthCheckExecutionResult> executionResults, String jsonpCallback, boolean includeDebug) {
        LOG.debug("Sending json response... ");
        StringWriter writer = new StringWriter();
        try {
            JSONWriter jsonWriter = new JSONWriter(writer);
            jsonWriter.object();
            jsonWriter.key("overallResult");
            jsonWriter.value(overallResult.getStatus().toString());
            jsonWriter.key("results");
            jsonWriter.array();
            for (HealthCheckExecutionResult healthCheckResult : executionResults) {
                this.writeResult(healthCheckResult, includeDebug, jsonWriter);
            }
            jsonWriter.endArray();
            jsonWriter.endObject();
        }
        catch (IOException e) {
            LOG.error("Could not serialise health check result: e=" + e, (Throwable)e);
            writer.write("{error:'" + e.getMessage() + "'}");
        }
        Object resultStr = writer.toString();
        if (StringUtils.isNotBlank(jsonpCallback)) {
            resultStr = jsonpCallback + "(" + (String)resultStr + ");";
        }
        return resultStr;
    }

    private void writeResult(HealthCheckExecutionResult healthCheckResult, boolean includeDebug, JSONWriter jsonWriter) throws IOException {
        jsonWriter.object().key("name").value(healthCheckResult.getHealthCheckMetadata().getTitle()).key("status").value(healthCheckResult.getHealthCheckResult().getStatus().toString()).key("timeInMs").value(healthCheckResult.getElapsedTimeInMs()).key("finishedAt").value(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").format(healthCheckResult.getFinishedAt()));
        jsonWriter.key("tags").array();
        for (String tag : healthCheckResult.getHealthCheckMetadata().getTags()) {
            jsonWriter.value(tag);
        }
        jsonWriter.endArray();
        jsonWriter.key("messages").array();
        for (ResultLog.Entry entry : healthCheckResult.getHealthCheckResult()) {
            if (!includeDebug && entry.isDebug()) continue;
            jsonWriter.object().key("status").value(entry.getStatus().toString()).key("message").value(entry.getMessage());
            Exception exception = entry.getException();
            if (exception != null) {
                StringWriter stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                jsonWriter.key("exception").value(stringWriter.toString());
            }
            jsonWriter.endObject();
        }
        jsonWriter.endArray();
        jsonWriter.endObject();
    }
}

