/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.jmx.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.management.DynamicMBean;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.core.impl.executor.ExtendedHealthCheckExecutor;
import org.apache.felix.hc.core.impl.util.HealthCheckFilter;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;
import org.apache.felix.hc.jmx.impl.HealthCheckMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class HealthCheckMBeanCreator {
    private static final String JMX_TYPE_NAME = "HealthCheck";
    private static final String JMX_DOMAIN = "org.apache.felix.healthcheck";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<ServiceReference<HealthCheck>, Registration> registeredServices = new HashMap<ServiceReference<HealthCheck>, Registration>();
    private final Map<String, List<ServiceReference<HealthCheck>>> sortedRegistrations = new HashMap<String, List<ServiceReference<HealthCheck>>>();
    private ServiceTracker<HealthCheck, ?> hcTracker;
    @Reference
    private ExtendedHealthCheckExecutor executor;

    @Activate
    protected void activate(BundleContext btx) {
        try {
            Filter filter = btx.createFilter("(&" + HealthCheckFilter.HC_FILTER_OBJECT_CLASS + "(hc.mbean.name=*))");
            this.hcTracker = new HealthCheckServiceTracker(btx, filter);
            this.hcTracker.open();
        }
        catch (InvalidSyntaxException e) {
            this.logger.warn("Could not create service tracker for filter " + HealthCheckFilter.HC_FILTER_OBJECT_CLASS, (Throwable)e);
        }
    }

    @Deactivate
    protected void deactivate() {
        if (this.hcTracker != null) {
            this.hcTracker.close();
            this.hcTracker = null;
        }
    }

    private synchronized Object registerHCMBean(BundleContext bundleContext, ServiceReference<HealthCheck> reference) {
        Registration reg = this.getRegistration(reference);
        if (reg != null) {
            this.registeredServices.put(reference, reg);
            List<ServiceReference<HealthCheck>> registered = this.sortedRegistrations.get(reg.name);
            if (registered == null) {
                registered = new ArrayList<ServiceReference<HealthCheck>>();
                this.sortedRegistrations.put(reg.name, registered);
            }
            registered.add(reference);
            Collections.sort(registered);
            int lastIndex = registered.size() - 1;
            if (registered.get(lastIndex).equals(reference)) {
                if (registered.size() > 1) {
                    ServiceReference<HealthCheck> prevRef = registered.get(lastIndex - 1);
                    Registration prevReg = this.registeredServices.get(prevRef);
                    prevReg.unregister();
                }
                reg.register(bundleContext);
            }
        }
        return reg;
    }

    private synchronized void unregisterHCMBean(BundleContext bundleContext, ServiceReference<HealthCheck> ref) {
        Registration reg = this.registeredServices.remove(ref);
        if (reg != null) {
            boolean registerFirst = reg.unregister();
            List<ServiceReference<HealthCheck>> registered = this.sortedRegistrations.get(reg.name);
            registered.remove(ref);
            if (registered.size() == 0) {
                this.sortedRegistrations.remove(reg.name);
            } else if (registerFirst) {
                ServiceReference<HealthCheck> newRef = registered.get(0);
                Registration newReg = this.registeredServices.get(newRef);
                newReg.register(bundleContext);
            }
            bundleContext.ungetService(ref);
        }
    }

    private Registration getRegistration(ServiceReference<HealthCheck> ref) {
        String hcMBeanName = (String)ref.getProperty("hc.mbean.name");
        if (StringUtils.isNotBlank(hcMBeanName)) {
            HealthCheckMBean mbean = new HealthCheckMBean(ref, this.executor);
            return new Registration(hcMBeanName.replace(',', '.'), mbean);
        }
        this.logger.warn("Service reference {} unexpectedly has property {} not set", ref, (Object)"hc.mbean.name");
        return null;
    }

    private final class Registration {
        private final String name;
        private final HealthCheckMBean mbean;
        private final String objectName;
        private ServiceRegistration<DynamicMBean> registration;

        Registration(String name, HealthCheckMBean mbean) {
            this.name = name;
            this.mbean = mbean;
            this.objectName = String.format("%s:type=%s,name=%s", HealthCheckMBeanCreator.JMX_DOMAIN, HealthCheckMBeanCreator.JMX_TYPE_NAME, name);
        }

        void register(BundleContext btx) {
            HealthCheckMBeanCreator.this.logger.debug("Registering health check mbean {} with name {}", (Object)this.mbean, (Object)this.objectName);
            Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
            ((Dictionary)mbeanProps).put("jmx.objectname", this.objectName);
            this.registration = btx.registerService(DynamicMBean.class, (Object)this.mbean, mbeanProps);
        }

        boolean unregister() {
            if (this.registration != null) {
                HealthCheckMBeanCreator.this.logger.debug("Unregistering health check mbean {} with name {}", (Object)this.mbean, (Object)this.objectName);
                this.registration.unregister();
                this.registration = null;
                return true;
            }
            return false;
        }
    }

    private final class HealthCheckServiceTracker
    extends ServiceTracker<HealthCheck, Object> {
        private final BundleContext bundleContext;

        private HealthCheckServiceTracker(BundleContext bundleContext, Filter filter) {
            super(bundleContext, filter, null);
            this.bundleContext = bundleContext;
        }

        public Object addingService(ServiceReference<HealthCheck> reference) {
            return HealthCheckMBeanCreator.this.registerHCMBean(this.bundleContext, reference);
        }

        public void modifiedService(ServiceReference<HealthCheck> reference, Object service) {
            HealthCheckMBeanCreator.this.unregisterHCMBean(this.bundleContext, reference);
            HealthCheckMBeanCreator.this.registerHCMBean(this.bundleContext, reference);
        }

        public void removedService(ServiceReference<HealthCheck> reference, Object service) {
            HealthCheckMBeanCreator.this.unregisterHCMBean(this.bundleContext, reference);
        }
    }
}

